/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import tico.board.TProject;
import tico.components.resources.ProjectAndroidFilter;
import tico.components.resources.ProjectFilter;
import tico.components.resources.TFileUtils;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.configuration.TSetup;
import tico.editor.TEditor;
import tico.editor.TProjectHandler;
import tico.editor.actions.TEditorAbstractAction;

public class TProjectSaveAsAction
extends TEditorAbstractAction {
    private static File defaultDirectory = null;

    public TProjectSaveAsAction(TEditor editor) {
        super(editor, TLanguage.getString("TProjectSaveAsAction.NAME"), TResourceManager.getImageIcon("archive-save-as-22.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(TLanguage.getString("TProjectSaveAsAction.SAVE_PROJECT"));
        fileChooser.setCurrentDirectory(defaultDirectory);
        fileChooser.setSelectedFile(new File(this.getEditor().getProject().getName()));
        ProjectFilter ticoFilter = new ProjectFilter();
        fileChooser.addChoosableFileFilter(ticoFilter);
        ProjectAndroidFilter androidFilter = new ProjectAndroidFilter();
        fileChooser.addChoosableFileFilter(androidFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (TEditor.get_android_mode()) {
            fileChooser.setFileFilter(androidFilter);
        } else {
            fileChooser.setFileFilter(ticoFilter);
        }
        int returnValue = fileChooser.showSaveDialog(null);
        if (returnValue == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            defaultDirectory = selectedFile.getParentFile();
            if (fileChooser.getFileFilter() instanceof ProjectFilter) {
                selectedFile = new File(TFileUtils.setExtension(selectedFile.getAbsolutePath(), "tco"));
                TEditor.set_android_mode(false);
            } else if (fileChooser.getFileFilter() instanceof ProjectAndroidFilter) {
                selectedFile = new File(TFileUtils.setExtension(selectedFile.getAbsolutePath(), "tcoa"));
                TEditor.set_android_mode(true);
            }
            if (selectedFile.exists() && JOptionPane.showConfirmDialog(null, String.valueOf(TLanguage.getString("TProjectSaveAsAction.CHOOSE_FILE_EXISTS")) + "\n" + TLanguage.getString("TProjectSaveAsAction.CHOOSE_FILE_EXISTS_QUESTION"), TLanguage.getString("TProjectSaveAsAction.CHOOSE_FILE_OVERWRITE"), 0) == 1) {
                return;
            }
            try {
                this.getEditor().getProject().setName(TFileUtils.getFilename(selectedFile));
                TProject project = this.getEditor().getProject();
                TProjectHandler.saveProject(project, selectedFile);
                this.getEditor().setModified(false);
                this.getEditor().setProjectFile(selectedFile);
                TSetup.setEditorHome(selectedFile.getParent().toString());
                this.getEditor().updateBoardButtons();
                this.getEditor().getContentPane().repaint();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TProjectSaveAsAction.SAVE_ERROR"), String.valueOf(TLanguage.getString("Error")) + "!", 0);
            }
        }
    }
}

