/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import tico.board.TProject;
import tico.components.resources.ProjectAndroidFilter;
import tico.components.resources.ProjectFilter;
import tico.components.resources.TFileUtils;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.configuration.TSetup;
import tico.editor.TEditor;
import tico.editor.TProjectHandler;
import tico.editor.actions.TEditorAbstractAction;

public class TProjectSaveAction
extends TEditorAbstractAction {
    private static File defaultDirectory = null;

    public TProjectSaveAction(TEditor editor) {
        super(editor, TLanguage.getString("TProjectSaveAction.NAME"), TResourceManager.getImageIcon("archive-save-22.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        File selectedFile = this.getEditor().getProjectFile();
        if (selectedFile == null) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(TLanguage.getString("TProjectSaveAction.SAVE_PROJECT"));
            fileChooser.setSelectedFile(new File(this.getEditor().getProject().getName()));
            fileChooser.setCurrentDirectory(defaultDirectory);
            ProjectFilter ticoFilter = new ProjectFilter();
            fileChooser.addChoosableFileFilter(ticoFilter);
            ProjectAndroidFilter androidFilter = new ProjectAndroidFilter();
            fileChooser.addChoosableFileFilter(androidFilter);
            fileChooser.setAcceptAllFileFilterUsed(false);
            if (TEditor.get_android_mode()) {
                fileChooser.setFileFilter(androidFilter);
            } else {
                fileChooser.setFileFilter(ticoFilter);
            }
            int returnValue = fileChooser.showSaveDialog(null);
            if (returnValue == 0) {
                selectedFile = fileChooser.getSelectedFile();
                defaultDirectory = selectedFile.getParentFile();
                if (fileChooser.getFileFilter() instanceof ProjectFilter) {
                    selectedFile = new File(TFileUtils.setExtension(selectedFile.getAbsolutePath(), "tco"));
                    TEditor.set_android_mode(false);
                } else if (fileChooser.getFileFilter() instanceof ProjectAndroidFilter) {
                    selectedFile = new File(TFileUtils.setExtension(selectedFile.getAbsolutePath(), "tcoa"));
                    TEditor.set_android_mode(true);
                }
                if (selectedFile.exists() && JOptionPane.showConfirmDialog(null, String.valueOf(TLanguage.getString("TProjectSaveAction.CHOOSE_FILE_EXISTS")) + "\n" + TLanguage.getString("TProjectSaveAction.CHOOSE_FILE_EXISTS_QUESTION"), TLanguage.getString("TProjectSaveAction.CHOOSE_FILE_OVERWRITE"), 0) == 1) {
                    return;
                }
            }
        }
        if (selectedFile != null) {
            try {
                this.getEditor().getProject().setName(TFileUtils.getFilename(selectedFile));
                TProject project = this.getEditor().getProject();
                TProjectHandler.saveProject(project, selectedFile);
                this.getEditor().setModified(false);
                this.getEditor().setProjectFile(selectedFile);
                TSetup.setEditorHome(selectedFile.getParent().toString());
                this.getEditor().updateBoardButtons();
                this.getEditor().getContentPane().repaint();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TProjectSaveAction.SAVE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
            }
        }
    }
}

