/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import tico.board.TBoardConstants;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TProjectPrintAction
extends TEditorAbstractAction {
    public TProjectPrintAction(TEditor editor) {
        super(editor, TLanguage.getString("TProjectPrintAction.NAME"), TResourceManager.getImageIcon("archive-print-22.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        int pages = this.getEditor().getBoardContainerCount();
        int i2 = 0;
        while (i2 < pages) {
            TBoardContainer boardContainer = this.getEditor().getBoardContainer(i2);
            boardContainer.getBoard().clearSelection();
            Dimension boardSize = TBoardConstants.getSize(boardContainer.getBoard().getAttributes(null));
            PageFormat page = printJob.defaultPage();
            if (boardSize.getWidth() > boardSize.getHeight()) {
                page.setOrientation(0);
            } else {
                page.setOrientation(1);
            }
            book.append(boardContainer, page);
            ++i2;
        }
        printJob.setPageable(book);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TProjectPrintAction.PRINT_ERROR"), String.valueOf(TLanguage.getString("TProjectPrintAction.ERROR")) + "!", 0);
            }
        }
    }
}

