/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import tico.components.resources.ProjectAndroidFilter;
import tico.components.resources.ProjectFilter;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.configuration.TSetup;
import tico.editor.TEditor;
import tico.editor.TProjectHandler;
import tico.editor.actions.TEditorAbstractAction;
import tico.editor.actions.TProjectSaveAction;

public class TProjectOpenAction
extends TEditorAbstractAction {
    private static File defaultDirectory = null;

    public TProjectOpenAction(TEditor editor) {
        super(editor, TLanguage.getString("TProjectOpenAction.NAME"), TResourceManager.getImageIcon("archive-open-22.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        int choosenOption = 1;
        if (this.getEditor().isModified()) {
            choosenOption = JOptionPane.showConfirmDialog(null, String.valueOf(TLanguage.getString("TProjectOpenAction.ASK_SAVE")) + "\n" + TLanguage.getString("TProjectOpenAction.ASK_SAVE_QUESTION"), TLanguage.getString("TProjectOpenAction.MODIFIED_PROJECT"), 1);
        }
        if (choosenOption == 2) {
            return;
        }
        if (choosenOption == 0) {
            new TProjectSaveAction(this.getEditor()).actionPerformed(e2);
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(TLanguage.getString("TProjectOpenAction.OPEN_PROJECT"));
        if (!TSetup.getEditorHome().equals("")) {
            defaultDirectory = new File(TSetup.getEditorHome());
        }
        fileChooser.setCurrentDirectory(defaultDirectory);
        ProjectFilter ticoFilter = new ProjectFilter();
        fileChooser.addChoosableFileFilter(ticoFilter);
        ProjectAndroidFilter androidFilter = new ProjectAndroidFilter();
        fileChooser.addChoosableFileFilter(androidFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (TEditor.get_android_mode()) {
            fileChooser.setFileFilter(androidFilter);
        } else {
            fileChooser.setFileFilter(ticoFilter);
        }
        int returnValue = fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            this.getEditor().changeToWaitingCursor();
            File selectedFile = fileChooser.getSelectedFile();
            defaultDirectory = selectedFile.getParentFile();
            TSetup.setEditorHome(selectedFile.getParent().toString());
            if (selectedFile.getName().endsWith("tcoa")) {
                TEditor.set_android_mode(true);
            } else {
                TEditor.set_android_mode(false);
            }
            try {
                this.getEditor().deleteProject();
                this.getEditor().setProject(TProjectHandler.loadProject(selectedFile));
                this.getEditor().setProjectFile(selectedFile);
                this.getEditor().restoreCursor();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TProjectOpenAction.OPEN_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
                this.getEditor().restoreCursor();
            }
        }
    }
}

