/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import tico.components.resources.TFileUtils;
import tico.components.resources.TicoFilter;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.TFileHandler;
import tico.editor.TProjectHandler;
import tico.editor.actions.TEditorAbstractAction;

public class TProjectImportAction
extends TEditorAbstractAction {
    private static File defaultDirectory = TFileHandler.getDefaultImportDirectory();

    public TProjectImportAction(TEditor editor) {
        super(editor, TLanguage.getString("TProjectImportAction.NAME"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(TLanguage.getString("TProjectImportAction.IMPORT"));
        fileChooser.setCurrentDirectory(defaultDirectory);
        fileChooser.addChoosableFileFilter(new TicoFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        int returnValue = fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            defaultDirectory = selectedFile.getParentFile();
            try {
                if (TFileUtils.isBoardFile(selectedFile)) {
                    this.getEditor().getProject().addBoard(TProjectHandler.loadBoard(selectedFile));
                } else if (TFileUtils.isProjectFile(selectedFile)) {
                    this.getEditor().getProject().addProject(TProjectHandler.loadProject(selectedFile));
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TProjectImportAction.IMPORT_ERROR"), String.valueOf(TLanguage.getString("Error")) + "!", 0);
            }
        }
    }
}

