/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JOptionPane;
import tico.board.TBoardConstants;
import tico.board.TBoardLayoutCache;
import tico.board.components.TCell;
import tico.board.components.TGrid;
import tico.board.components.TGridCell;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TInsertGridCellAction
extends TEditorAbstractAction {
    private TGrid grid;
    private TCell cell;

    public TInsertGridCellAction(TEditor editor, TCell cell, TGrid grid) {
        super(editor, TBoardConstants.getId(grid.getAttributes()));
        this.cell = cell;
        this.grid = grid;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        ArrayList<TPoint> options = new ArrayList<TPoint>();
        int order = TBoardConstants.getOrder(this.grid.getAttributes());
        switch (order) {
            case 2: {
                int rows = this.grid.getLastColumnRow(1);
                int i2 = 1;
                while (i2 <= rows) {
                    options.add(new TPoint(this.grid.getLastRowColumn(i2) + 1, i2));
                    ++i2;
                }
                options.add(new TPoint(1, rows + 1));
                break;
            }
            case 1: {
                int columns = this.grid.getLastRowColumn(1);
                int i2 = 1;
                while (i2 <= columns) {
                    options.add(new TPoint(i2, this.grid.getLastColumnRow(i2) + 1));
                    ++i2;
                }
                options.add(new TPoint(columns + 1, 1));
                break;
            }
            default: {
                int columns = this.grid.getLastRowColumn(1);
                int i2 = 1;
                while (i2 <= columns) {
                    options.add(new TPoint(i2, this.grid.getLastColumnRow(i2) + 1));
                    ++i2;
                }
                int rows = this.grid.getLastColumnRow(1);
                i2 = 1;
                while (i2 <= rows) {
                    options.add(new TPoint(this.grid.getLastRowColumn(i2) + 1, i2));
                    ++i2;
                }
                break block0;
            }
        }
        TPoint option = (TPoint)JOptionPane.showInputDialog(this.editor, TLanguage.getString("TInsertGridCellAction.CHOOSE_POSITION"), TLanguage.getString("TInsertGridCellAction.POSITION"), -1, null, options.toArray(), options.get(0));
        if (option != null) {
            int newCol = (int)option.getY();
            int newRow = (int)option.getX();
            TGridCell newCell = new TGridCell(newRow, newCol);
            Map newCellAttributes = (Map)this.cell.getAttributes().clone();
            TBoardConstants.setBrowseable(newCellAttributes, false);
            newCell.getAttributes().applyMap(newCellAttributes);
            TBoardConstants.setColumn(newCell.getAttributes(), newCol);
            TBoardConstants.setRow(newCell.getAttributes(), newRow);
            ((TBoardLayoutCache)this.getEditor().getCurrentBoard().getGraphLayoutCache()).removeAndInsertGroup(new Object[]{this.cell}, this.grid, new Object[]{newCell});
        }
    }

    private class TPoint
    extends Point {
        public TPoint(int x2, int y2) {
            super(x2, y2);
        }

        @Override
        public String toString() {
            return "(" + (int)this.getX() + "," + (int)this.getY() + ")";
        }
    }
}

