/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoardConstants;
import tico.board.TBoardLayoutCache;
import tico.board.components.TCell;
import tico.board.components.TGrid;
import tico.board.components.TGridCell;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TExtractGridCellAction
extends TEditorAbstractAction {
    private TGridCell cell;

    public TExtractGridCellAction(TEditor editor, TGridCell cell) {
        super(editor, TLanguage.getString("TExtractGridCellAction.NAME"));
        this.cell = cell;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Hashtable nested = new Hashtable();
        TGrid grid = (TGrid)this.cell.getParent();
        List children = grid.getChildren();
        int order = TBoardConstants.getOrder(grid.getAttributes());
        int delCol = TBoardConstants.getColumn(this.cell.getAttributes());
        int delRow = TBoardConstants.getRow(this.cell.getAttributes());
        int colSize = grid.getLastRowColumn(delCol);
        int rowSize = grid.getLastColumnRow(delRow);
        int i2 = 0;
        while (i2 < children.size()) {
            AttributeMap attributeMap;
            int curCol = TBoardConstants.getColumn(((TGridCell)children.get(i2)).getAttributes());
            int curRow = TBoardConstants.getRow(((TGridCell)children.get(i2)).getAttributes());
            if (order == 1) {
                if (rowSize == 1 && delRow < curRow) {
                    attributeMap = new AttributeMap();
                    TBoardConstants.setRow(attributeMap, curRow - 1);
                    nested.put(children.get(i2), attributeMap);
                }
                if (delCol < curCol && delRow == curRow) {
                    attributeMap = new AttributeMap();
                    TBoardConstants.setColumn(attributeMap, curCol - 1);
                    nested.put(children.get(i2), attributeMap);
                }
            } else {
                if (colSize == 1 && delCol < curCol) {
                    attributeMap = new AttributeMap();
                    TBoardConstants.setColumn(attributeMap, curCol - 1);
                    nested.put(children.get(i2), attributeMap);
                }
                if (delRow < curRow && delCol == curCol) {
                    attributeMap = new AttributeMap();
                    TBoardConstants.setRow(attributeMap, curRow - 1);
                    nested.put(children.get(i2), attributeMap);
                }
            }
            ++i2;
        }
        TCell newCell = new TCell();
        Map newCellAttributes = (Map)this.cell.getAttributes().clone();
        TBoardConstants.setBrowseable(newCellAttributes, true);
        newCell.getAttributes().applyMap(newCellAttributes);
        ((TBoardLayoutCache)this.getEditor().getCurrentBoard().getGraphLayoutCache()).removeInsertAndEdit(new Object[]{newCell}, new Object[]{this.cell}, nested);
    }
}

