/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Map;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoardConstants;
import tico.board.components.TGrid;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TChangeGridOrderAction
extends TEditorAbstractAction {
    private TGrid grid;
    private int order;

    public TChangeGridOrderAction(TEditor editor, TGrid grid, int order) {
        super(editor, String.valueOf(TLanguage.getString("TChangeGridOrderAction.NAME")) + " " + (order == 2 ? TLanguage.getString("TChangeGridOrderAction.COLUMNS") : TLanguage.getString("TChangeGridOrderAction.ROWS")));
        this.grid = grid;
        this.order = order;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Map<TGrid, AttributeMap> nested = new Hashtable();
        int prevOrder = TBoardConstants.getOrder(this.grid.getAttributes());
        if (this.order == 2 && prevOrder != this.order) {
            nested = this.grid.reorderColumns();
        } else if (this.order == 1 && prevOrder != this.order) {
            nested = this.grid.reorderRows();
        }
        if (prevOrder != this.order) {
            AttributeMap attributeMap = new AttributeMap();
            TBoardConstants.setOrder(attributeMap, this.order);
            nested.put(this.grid, attributeMap);
        }
        if (!nested.isEmpty()) {
            this.getEditor().getCurrentBoard().getGraphLayoutCache().edit(nested, null, null, null);
        }
    }
}

