/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import tico.components.resources.CustomFilter;
import tico.components.resources.TFileUtils;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TBoardExportImageAction
extends TEditorAbstractAction {
    private static File defaultDirectory = null;
    private String fileType = "png";

    public TBoardExportImageAction(TEditor editor, String fileType) {
        super(editor, String.valueOf(TLanguage.getString("TBoardExportImageAction.NAME")) + " " + fileType.toUpperCase());
        this.fileType = fileType;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (this.getEditor().getCurrentBoard() == null) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TBoardExportImageAction.NO_BOARD_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(String.valueOf(TLanguage.getString("TBoardExportImageAction.NAME")) + " " + this.fileType.toUpperCase());
        fileChooser.setCurrentDirectory(defaultDirectory);
        fileChooser.setSelectedFile(new File(String.valueOf(this.getEditor().getCurrentBoard().getBoardName()) + "." + this.fileType));
        fileChooser.addChoosableFileFilter(new CustomFilter(this.fileType));
        fileChooser.setAcceptAllFileFilterUsed(false);
        int returnValue = fileChooser.showSaveDialog(null);
        if (returnValue == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            defaultDirectory = selectedFile.getParentFile();
            if ((selectedFile = new File(TFileUtils.setExtension(selectedFile.getAbsolutePath(), this.fileType))).exists() && JOptionPane.showConfirmDialog(null, String.valueOf(TLanguage.getString("TBoardExportImageAction.CHOOSE_FILE_EXISTS")) + "\n" + TLanguage.getString("TBoardExportImageAction.CHOOSE_FILE_EXISTS_QUESTION"), TLanguage.getString("TBoardExportImageAction.CHOOSE_FILE_OVERWRITE"), 0) == 1) {
                return;
            }
            try {
                this.getEditor().getCurrentBoard().clearSelection();
                BufferedImage img = this.getEditor().getCurrentBoard().getImage();
                ImageIO.write((RenderedImage)img, this.fileType, selectedFile);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TBoardExportImageAction.EXPORT_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
            }
        }
    }
}

