/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import tico.board.TBoard;
import tico.components.resources.BoardFilter;
import tico.components.resources.TFileUtils;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.TFileHandler;
import tico.editor.TProjectHandler;
import tico.editor.actions.TEditorAbstractAction;

public class TBoardExportAction
extends TEditorAbstractAction {
    private static File defaultDirectory = TFileHandler.getDefaultImportDirectory();

    public TBoardExportAction(TEditor editor) {
        super(editor, TLanguage.getString("TBoardExportAction.NAME"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (this.getEditor().getCurrentBoard() == null) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TBoardExportAction.NO_BOARD_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(TLanguage.getString("TBoardExportAction.CHOOSE_EXPORT_BOARD"));
        fileChooser.setSelectedFile(new File(String.valueOf(this.getEditor().getCurrentBoard().getBoardName()) + "." + "brd"));
        fileChooser.setCurrentDirectory(defaultDirectory);
        fileChooser.addChoosableFileFilter(new BoardFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        int returnValue = fileChooser.showSaveDialog(null);
        if (returnValue == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            defaultDirectory = selectedFile.getParentFile();
            if ((selectedFile = new File(TFileUtils.setExtension(selectedFile.getAbsolutePath(), "brd"))).exists() && JOptionPane.showConfirmDialog(null, String.valueOf(TLanguage.getString("TBoardExportAction.CHOOSE_FILE_EXISTS")) + "\n" + TLanguage.getString("TBoardExportAction.CHOOSE_FILE_EXISTS_QUESTION"), TLanguage.getString("TBoardExportAction.CHOOSE_FILE_OVERWRITE"), 0) == 1) {
                return;
            }
            try {
                TBoard board = this.getEditor().getCurrentBoard();
                TProjectHandler.saveBoard(board, selectedFile);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TBoardExportAction.EXPORT_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
            }
        }
    }
}

