/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.board.components.TGrid;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TAlignTopAction
extends TEditorAbstractAction {
    public TAlignTopAction(TEditor editor) {
        super(editor, TLanguage.getString("TAlignTopAction.NAME"), TResourceManager.getImageIcon("align-top-22.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Hashtable<TComponent, AttributeMap> nested = new Hashtable<TComponent, AttributeMap>();
        Object[] selectedCells = this.getEditor().getCurrentBoard().getSelectionCells();
        int i2 = 0;
        while (i2 < selectedCells.length) {
            if (selectedCells[i2] instanceof TGrid) {
                this.getEditor().getCurrentBoard().removeSelectionCell(selectedCells[i2]);
            }
            ++i2;
        }
        int selectedCellsCount = this.getEditor().getCurrentBoard().getSelectionCount();
        if (selectedCellsCount < 2) {
            return;
        }
        TComponent referenceCell = (TComponent)this.getEditor().getCurrentBoard().getSelectionCells()[0];
        Rectangle2D referenceBounds = TBoardConstants.getBounds(referenceCell.getAttributes());
        i2 = 1;
        while (i2 < selectedCellsCount) {
            AttributeMap attributeMap = new AttributeMap();
            TComponent currentCell = (TComponent)this.getEditor().getCurrentBoard().getSelectionCells()[i2];
            Rectangle2D currentBounds = TBoardConstants.getBounds(currentCell.getAttributes());
            Rectangle2D.Double newBounds = new Rectangle2D.Double(currentBounds.getX(), referenceBounds.getY(), currentBounds.getWidth(), currentBounds.getHeight());
            TBoardConstants.setBounds(attributeMap, newBounds);
            nested.put(currentCell, attributeMap);
            ++i2;
        }
        this.getEditor().getCurrentBoard().getGraphLayoutCache().edit(nested, null, null, null);
    }
}

