/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.board.components.TGrid;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TAdjustHorizontalGapAction
extends TEditorAbstractAction {
    public TAdjustHorizontalGapAction(TEditor editor) {
        super(editor, TLanguage.getString("TAdjustHorizontalGapAction.NAME"), TResourceManager.getImageIcon("align-horizontal-gap-22.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        TComponent currentCell;
        Rectangle2D currentBounds;
        Hashtable<TComponent, AttributeMap> nested = new Hashtable<TComponent, AttributeMap>();
        Object[] selectedCells = this.getEditor().getCurrentBoard().getSelectionCells();
        int i2 = 0;
        while (i2 < selectedCells.length) {
            if (selectedCells[i2] instanceof TGrid) {
                this.getEditor().getCurrentBoard().removeSelectionCell(selectedCells[i2]);
            }
            ++i2;
        }
        int selectedCellsCount = this.getEditor().getCurrentBoard().getSelectionCount();
        if (selectedCellsCount < 3) {
            return;
        }
        ArrayList<Object> unorderedCells = new ArrayList<Object>();
        ArrayList<TComponent> orderedCells = new ArrayList<TComponent>();
        i2 = 0;
        while (i2 < selectedCellsCount) {
            unorderedCells.add(this.getEditor().getCurrentBoard().getSelectionCells()[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < selectedCellsCount) {
            TComponent minCell = (TComponent)unorderedCells.get(0);
            currentBounds = TBoardConstants.getBounds(minCell.getAttributes());
            double minPosition = currentBounds.getX();
            int j2 = 1;
            while (j2 < unorderedCells.size()) {
                currentCell = (TComponent)unorderedCells.get(j2);
                currentBounds = TBoardConstants.getBounds(currentCell.getAttributes());
                if (currentBounds.getX() < minPosition) {
                    minPosition = currentBounds.getX();
                    minCell = currentCell;
                }
                ++j2;
            }
            orderedCells.add(minCell);
            unorderedCells.remove(minCell);
            ++i2;
        }
        double horizontalGapSize = TBoardConstants.getBounds(((TComponent)orderedCells.get(orderedCells.size() - 1)).getAttributes()).getX() - TBoardConstants.getBounds(((TComponent)orderedCells.get(0)).getAttributes()).getX();
        i2 = 0;
        while (i2 < selectedCellsCount - 1) {
            horizontalGapSize -= TBoardConstants.getBounds(((TComponent)orderedCells.get(i2)).getAttributes()).getWidth();
            ++i2;
        }
        horizontalGapSize /= (double)(orderedCells.size() - 1);
        double lastCellPlace = TBoardConstants.getBounds(((TComponent)orderedCells.get(0)).getAttributes()).getX() + TBoardConstants.getBounds(((TComponent)orderedCells.get(0)).getAttributes()).getWidth();
        i2 = 1;
        while (i2 < selectedCellsCount - 1) {
            AttributeMap attributeMap = new AttributeMap();
            currentCell = (TComponent)orderedCells.get(i2);
            currentBounds = TBoardConstants.getBounds(currentCell.getAttributes());
            Rectangle2D.Double newBounds = new Rectangle2D.Double(lastCellPlace + horizontalGapSize, currentBounds.getY(), currentBounds.getWidth(), currentBounds.getHeight());
            TBoardConstants.setBounds(attributeMap, newBounds);
            nested.put(currentCell, attributeMap);
            lastCellPlace += horizontalGapSize + currentBounds.getWidth();
            ++i2;
        }
        this.getEditor().getCurrentBoard().getGraphLayoutCache().edit(nested, null, null, null);
    }
}

