/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import tico.board.TBoardConstants;
import tico.board.components.TGrid;
import tico.board.components.TGridCell;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TAddGridRowAction
extends TEditorAbstractAction {
    private TGrid grid;

    public TAddGridRowAction(TEditor editor, TGrid grid) {
        super(editor, TLanguage.getString("TAddGridRowAction.NAME"));
        this.grid = grid;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        int numNewCells = this.grid.getColumnsCount();
        Object[] newCells = new TGridCell[numNewCells];
        AttributeMap currentAttributes = this.editor.getCurrentAttributes();
        int i2 = 1;
        while (i2 <= numNewCells) {
            double verticalDistance;
            int lastColumnRow = this.grid.getLastRowColumn(i2);
            newCells[i2 - 1] = new TGridCell(lastColumnRow + 1, i2);
            ((DefaultGraphCell)newCells[i2 - 1]).getAttributes().applyMap(currentAttributes);
            Rectangle2D newCellDimension = TBoardConstants.getBounds(this.grid.getCell(lastColumnRow, i2).getAttributes());
            if (this.grid.getCell(lastColumnRow - 1, i2) == null) {
                verticalDistance = 10.0 + newCellDimension.getHeight();
            } else {
                Rectangle2D previousRowCell = TBoardConstants.getBounds(this.grid.getCell(lastColumnRow - 1, i2).getAttributes());
                verticalDistance = newCellDimension.getY() - previousRowCell.getY() - previousRowCell.getHeight() + newCellDimension.getHeight();
            }
            TBoardConstants.setBounds(((DefaultGraphCell)newCells[i2 - 1]).getAttributes(), new Rectangle2D.Double(newCellDimension.getX(), newCellDimension.getY() + verticalDistance, newCellDimension.getWidth(), newCellDimension.getHeight()));
            ++i2;
        }
        this.getEditor().getCurrentBoard().getGraphLayoutCache().insertGroup(this.grid, newCells);
    }
}

