/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import tico.board.TBoardConstants;
import tico.board.components.TGrid;
import tico.board.components.TGridCell;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TAddGridColumnAction
extends TEditorAbstractAction {
    private TGrid grid;

    public TAddGridColumnAction(TEditor editor, TGrid grid) {
        super(editor, TLanguage.getString("TAddGridColumnAction.NAME"));
        this.grid = grid;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        int numNewCells = this.grid.getRowsCount();
        Object[] newCells = new TGridCell[numNewCells];
        AttributeMap currentAttributes = this.editor.getCurrentAttributes();
        int i2 = 1;
        while (i2 <= numNewCells) {
            double horizontalDistance;
            int lastRowColumn = this.grid.getLastColumnRow(i2);
            newCells[i2 - 1] = new TGridCell(i2, lastRowColumn + 1);
            ((DefaultGraphCell)newCells[i2 - 1]).getAttributes().applyMap(currentAttributes);
            Rectangle2D newCellDimension = TBoardConstants.getBounds(this.grid.getCell(i2, lastRowColumn).getAttributes());
            if (this.grid.getCell(i2, lastRowColumn - 1) == null) {
                horizontalDistance = 10.0 + newCellDimension.getWidth();
            } else {
                Rectangle2D previousRowCell = TBoardConstants.getBounds(this.grid.getCell(i2, lastRowColumn - 1).getAttributes());
                horizontalDistance = newCellDimension.getX() - previousRowCell.getX() - previousRowCell.getWidth() + newCellDimension.getWidth();
            }
            TBoardConstants.setBounds(((DefaultGraphCell)newCells[i2 - 1]).getAttributes(), new Rectangle2D.Double(newCellDimension.getX() + horizontalDistance, newCellDimension.getY(), newCellDimension.getWidth(), newCellDimension.getHeight()));
            ++i2;
        }
        this.getEditor().getCurrentBoard().getGraphLayoutCache().insertGroup(this.grid, newCells);
    }
}

