/*
 * Decompiled with CFR 0.152.
 */
package tico.editor.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoardConstants;
import tico.board.components.TGrid;
import tico.board.components.TGridCell;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.actions.TEditorAbstractAction;

public class TAddGridCellAction
extends TEditorAbstractAction {
    private TGrid grid;

    public TAddGridCellAction(TEditor editor, TGrid grid) {
        super(editor, TLanguage.getString("TAddGridCellAction.NAME"));
        this.grid = grid;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        ArrayList<TPoint> options = new ArrayList<TPoint>();
        int order = TBoardConstants.getOrder(this.grid.getAttributes());
        AttributeMap currentAttributes = this.editor.getCurrentAttributes();
        switch (order) {
            case 2: {
                int rows = this.grid.getLastColumnRow(1);
                int i2 = 1;
                while (i2 <= rows) {
                    options.add(new TPoint(this.grid.getLastRowColumn(i2) + 1, i2));
                    ++i2;
                }
                options.add(new TPoint(1, rows + 1));
                break;
            }
            case 1: {
                int columns = this.grid.getLastRowColumn(1);
                int i2 = 1;
                while (i2 <= columns) {
                    options.add(new TPoint(i2, this.grid.getLastColumnRow(i2) + 1));
                    ++i2;
                }
                options.add(new TPoint(columns + 1, 1));
                break;
            }
            default: {
                int columns = this.grid.getLastRowColumn(1);
                int i2 = 1;
                while (i2 <= columns) {
                    options.add(new TPoint(i2, this.grid.getLastColumnRow(i2) + 1));
                    ++i2;
                }
                int rows = this.grid.getLastColumnRow(1);
                i2 = 1;
                while (i2 <= rows) {
                    options.add(new TPoint(this.grid.getLastRowColumn(i2) + 1, i2));
                    ++i2;
                }
                break block0;
            }
        }
        TPoint option = (TPoint)JOptionPane.showInputDialog(this.getEditor(), TLanguage.getString("TAddGridCellAction.CHOOSE_POSITION"), TLanguage.getString("TAddGridCellAction.POSITION"), -1, null, options.toArray(), options.get(0));
        if (option != null) {
            Rectangle2D.Double bounds;
            int newCol = (int)option.getY();
            int newRow = (int)option.getX();
            TGridCell newCell = new TGridCell(newRow, newCol);
            if (order == 2 || order == 3 && this.grid.getLastColumnRow(newRow) == 0 || order == 0 && this.grid.getLastColumnRow(newRow) == 0) {
                int newCellColumnDimension = this.grid.getLastRowColumn(newCol);
                if (newCellColumnDimension > 0) {
                    double verticalDistance;
                    Rectangle2D newCellDimension = TBoardConstants.getBounds(this.grid.getCell(newCellColumnDimension, newCol).getAttributes());
                    if (newCellColumnDimension == 1) {
                        verticalDistance = 10.0 + newCellDimension.getHeight();
                    } else {
                        Rectangle2D previousRowCell = TBoardConstants.getBounds(this.grid.getCell(newCellColumnDimension - 1, newCol).getAttributes());
                        verticalDistance = newCellDimension.getY() - previousRowCell.getY() - previousRowCell.getHeight() + newCellDimension.getHeight();
                    }
                    bounds = new Rectangle2D.Double(newCellDimension.getX(), newCellDimension.getY() + verticalDistance, newCellDimension.getWidth(), newCellDimension.getHeight());
                } else {
                    Rectangle2D newCellDimension = TBoardConstants.getBounds(this.grid.getCell(newRow, newCol - 1).getAttributes());
                    double horizontalDistance = 10.0 + newCellDimension.getWidth();
                    bounds = new Rectangle2D.Double(newCellDimension.getX() + horizontalDistance, newCellDimension.getY(), newCellDimension.getWidth(), newCellDimension.getHeight());
                }
            } else {
                int newCellRowDimension = this.grid.getLastColumnRow(newRow);
                if (newCellRowDimension > 0) {
                    double horizontalDistance;
                    Rectangle2D newCellDimension = TBoardConstants.getBounds(this.grid.getCell(newRow, newCellRowDimension).getAttributes());
                    if (newCellRowDimension == 1) {
                        horizontalDistance = 10.0 + newCellDimension.getWidth();
                    } else {
                        Rectangle2D previousRowCell = TBoardConstants.getBounds(this.grid.getCell(newRow, newCellRowDimension - 1).getAttributes());
                        horizontalDistance = newCellDimension.getX() - previousRowCell.getX() - previousRowCell.getWidth() + newCellDimension.getWidth();
                    }
                    bounds = new Rectangle2D.Double(newCellDimension.getX() + horizontalDistance, newCellDimension.getY(), newCellDimension.getWidth(), newCellDimension.getHeight());
                } else {
                    Rectangle2D newCellDimension = TBoardConstants.getBounds(this.grid.getCell(newRow - 1, newCol).getAttributes());
                    double verticalDistance = 10.0 + newCellDimension.getHeight();
                    bounds = new Rectangle2D.Double(newCellDimension.getX(), newCellDimension.getY() + verticalDistance, newCellDimension.getWidth(), newCellDimension.getHeight());
                }
            }
            newCell.getAttributes().applyMap(currentAttributes);
            TBoardConstants.setBounds(newCell.getAttributes(), bounds);
            this.getEditor().getCurrentBoard().getGraphLayoutCache().insertGroup(this.grid, new Object[]{newCell});
        }
    }

    private class TPoint
    extends Point {
        public TPoint(int x2, int y2) {
            super(x2, y2);
        }

        @Override
        public String toString() {
            return "(" + (int)this.getX() + "," + (int)this.getY() + ")";
        }
    }
}

