/*
 * Decompiled with CFR 0.152.
 */
package tico.editor;

import database.DB;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import tico.board.TBoard;
import tico.board.TProject;
import tico.board.encoding.InvalidFormatException;
import tico.board.encoding.TAttributeEncoder;
import tico.editor.TFileHandler;
import tico.interpreter.TInterpreterProject;

public class TProjectHandler {
    private static final int ZIP_BUFFER_SIZE = 2048;
    private static String tempDirectoryPath;
    private static File tempDirectory;

    static {
        tempDirectory = new File(TFileHandler.getCurrentDirectory(), "temp");
        tempDirectoryPath = tempDirectory.getAbsolutePath();
        tempDirectory.mkdirs();
    }

    public static File getTempDirectory() {
        return tempDirectory;
    }

    public static String getTempDirectoryPath() {
        return tempDirectoryPath;
    }

    public static void deleteTempDirectory() {
        TFileHandler.deleteDirectory(tempDirectory);
        tempDirectory.delete();
    }

    public static void cleanTempDirectory() {
        TFileHandler.deleteDirectory(tempDirectory);
    }

    public static void copyCurrentToTemp(String[] partialPaths) throws IOException {
        int i2 = 0;
        while (i2 < partialPaths.length) {
            File dstFile = new File(tempDirectory, partialPaths[i2]);
            if (!dstFile.getParentFile().exists()) {
                dstFile.getParentFile().mkdirs();
            }
            try {
                File orFile = new File(String.valueOf(DB.getInstance().getImagesPath()) + File.separator + partialPaths[i2].substring(partialPaths[i2].lastIndexOf(File.separator)));
                TFileHandler.copyFile(orFile, dstFile);
            }
            catch (IOException e2) {
                TFileHandler.copyFile(new File(TFileHandler.getCurrentDirectory(), partialPaths[i2]), dstFile);
            }
            catch (SQLException e3) {
                throw new IOException();
            }
            ++i2;
        }
    }

    public static void saveZip(File zipFile) throws IOException {
        if (zipFile.exists()) {
            zipFile.delete();
        }
        TProjectHandler.zip(tempDirectory, zipFile);
    }

    public static void loadZip(File zipFile) throws IOException {
        TProjectHandler.unzip(zipFile, tempDirectory);
    }

    public static void saveProject(TProject project, File zipFile) throws ParserConfigurationException, IOException, TransformerException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document doc = domBuilder.newDocument();
        doc.appendChild(project.XMLEncode(doc));
        TProjectHandler.cleanTempDirectory();
        TProjectHandler.copyCurrentToTemp(TAttributeEncoder.getFilePaths(doc));
        File file = new File(TProjectHandler.getTempDirectory(), "project.xml");
        BufferedWriter bufferWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(bufferWriter);
        transformer.transform(source, result);
        bufferWriter.close();
        TProjectHandler.saveZip(zipFile);
        TProjectHandler.cleanTempDirectory();
    }

    public static void saveBoard(TBoard board, File zipFile) throws ParserConfigurationException, IOException, TransformerException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document doc = domBuilder.newDocument();
        doc.appendChild(board.XMLEncode(doc));
        TProjectHandler.cleanTempDirectory();
        TProjectHandler.copyCurrentToTemp(TAttributeEncoder.getFilePaths(doc));
        File file = new File(TProjectHandler.getTempDirectory(), "board.xml");
        BufferedWriter bufferWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(bufferWriter);
        transformer.transform(source, result);
        bufferWriter.close();
        TProjectHandler.saveZip(zipFile);
    }

    public static TProject loadProject(File zipFile) throws IOException, ParserConfigurationException, InvalidFormatException, SAXException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        TProjectHandler.cleanTempDirectory();
        TProjectHandler.loadZip(zipFile);
        String projectName = zipFile.getName();
        projectName = projectName.substring(0, projectName.lastIndexOf(46));
        File file = new File(TProjectHandler.getTempDirectory(), "project.xml");
        Document doc = docBuilder.parse(file);
        TProject project = TProject.XMLDecode(doc.getDocumentElement(), projectName);
        TProjectHandler.cleanTempDirectory();
        return project;
    }

    public static TInterpreterProject loadProjectInterpreter(File zipFile) throws IOException, ParserConfigurationException, InvalidFormatException, SAXException {
        TProjectHandler.cleanTempDirectory();
        TProjectHandler.loadZip(zipFile);
        String projectName = zipFile.getName();
        projectName = projectName.substring(0, projectName.lastIndexOf(46));
        File file = new File(TProjectHandler.getTempDirectory(), "project.xml");
        TInterpreterProject project = TInterpreterProject.XMLDecode(file, projectName);
        TProjectHandler.cleanTempDirectory();
        return project;
    }

    public static TBoard loadBoard(File zipFile) throws ParserConfigurationException, IOException, SAXException, InvalidFormatException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        TProjectHandler.cleanTempDirectory();
        TProjectHandler.loadZip(zipFile);
        File file = new File(TProjectHandler.getTempDirectory(), "board.xml");
        Document doc = docBuilder.parse(file);
        TBoard board = TBoard.XMLDecode(doc.getDocumentElement());
        TProjectHandler.cleanTempDirectory();
        return board;
    }

    private static void zip(File srcDir, File dstFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dstFile));
        TProjectHandler.zip(srcDir, srcDir, zos);
        zos.close();
    }

    private static void zip(File srcDir, File originSrcDir, ZipOutputStream dstStream) throws IOException {
        byte[] buffer = new byte[2048];
        int bytes = 0;
        String[] dirList = srcDir.list();
        int i2 = 0;
        while (i2 < dirList.length) {
            File file = new File(srcDir, dirList[i2]);
            if (file.isDirectory()) {
                TProjectHandler.zip(file, originSrcDir, dstStream);
            } else {
                FileInputStream fis = new FileInputStream(file);
                ZipEntry entry = new ZipEntry(TFileHandler.removeDirectoryPath(originSrcDir.getAbsolutePath(), file.getAbsolutePath()));
                dstStream.putNextEntry(entry);
                while ((bytes = fis.read(buffer)) != -1) {
                    dstStream.write(buffer, 0, bytes);
                }
                fis.close();
            }
            ++i2;
        }
    }

    private static void unzip(File srcFile, File dstDir) throws IOException {
        byte[] buffer = new byte[2048];
        ZipFile zipFile = new ZipFile(srcFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            int bytes;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                File newDirectory = new File(entry.getName());
                if (newDirectory.exists()) continue;
                newDirectory.mkdirs();
                continue;
            }
            File newFile = new File(dstDir, entry.getName().replace('\\', '/'));
            File newFileDir = newFile.getParentFile();
            if (!newFileDir.exists()) {
                newFileDir.mkdirs();
            }
            InputStream in = zipFile.getInputStream(entry);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
            while ((bytes = in.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, bytes);
            }
            in.close();
            ((OutputStream)out).close();
        }
        zipFile.close();
    }
}

