/*
 * Decompiled with CFR 0.152.
 */
package tico.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import tico.components.resources.TFileUtils;

public class TFileHandler {
    private static final String CURRENT_BASE_DIRECTORY_PATH = "current";
    private static final File CURRENT_BASE_DIRECTORY = new File("current");
    private static final File DEFAULT_IMPORT_DIR = new File("templates");
    private static String currentDirectoryPath;
    private static File currentDirectory;

    static {
        if (!CURRENT_BASE_DIRECTORY.exists()) {
            CURRENT_BASE_DIRECTORY.mkdirs();
        }
        int i2 = 0;
        currentDirectory = new File(CURRENT_BASE_DIRECTORY_PATH + File.separator + i2++);
        while (currentDirectory.exists()) {
            currentDirectory = new File(CURRENT_BASE_DIRECTORY_PATH + File.separator + i2++);
        }
        currentDirectoryPath = currentDirectory.getAbsolutePath();
        currentDirectory.mkdirs();
    }

    public static File importFile(String fileAbsolutePath) throws IOException {
        File file = new File(fileAbsolutePath);
        return TFileHandler.importFile(file);
    }

    public static File importFile(File file) throws IOException {
        File directory;
        String directoryPath = currentDirectoryPath;
        if (TFileUtils.isImageFile(file)) {
            directoryPath = String.valueOf(directoryPath) + File.separator + "image";
        }
        if (TFileUtils.isSoundFile(file)) {
            directoryPath = String.valueOf(directoryPath) + File.separator + "sound";
        }
        if (TFileUtils.isVideoFile(file)) {
            directoryPath = String.valueOf(directoryPath) + File.separator + "video";
        }
        if (!(directory = new File(directoryPath)).exists()) {
            directory.mkdirs();
        }
        return TFileHandler.importFile(file, directory);
    }

    public static void remove(String fileAbsolutePath) {
        File file = new File(fileAbsolutePath);
        TFileHandler.remove(file);
    }

    private static File importFile(File srcFile, File dstDir) throws IOException {
        String baseFilename;
        File newFile;
        String name = TFileHandler.getFilename(srcFile.getName());
        String extension = TFileHandler.getExtension(srcFile.getName());
        String nameRenamed = TFileHandler.replace(name);
        if (!nameRenamed.equals(name)) {
            newFile = new File(dstDir, String.valueOf(nameRenamed) + "." + extension);
            baseFilename = String.valueOf(nameRenamed) + "." + extension;
        } else {
            newFile = new File(dstDir, srcFile.getName());
            baseFilename = srcFile.getName();
        }
        if (!dstDir.exists() || !dstDir.canWrite()) {
            throw new IOException("Invalid destination directory");
        }
        if (!srcFile.exists() || srcFile.isDirectory()) {
            throw new IOException("Invalid input file");
        }
        if (!srcFile.canRead()) {
            throw new IOException("Input file can't be read");
        }
        int fileCount = 1;
        while (newFile.exists()) {
            newFile = new File(dstDir, String.valueOf(TFileUtils.getFilename(baseFilename)) + "_" + fileCount++ + "." + TFileUtils.getExtension(baseFilename));
        }
        newFile.createNewFile();
        TFileHandler.copyFile(srcFile, newFile);
        return newFile;
    }

    private static void remove(File file) {
        file.delete();
    }

    public static File getCurrentDirectory() {
        return currentDirectory;
    }

    public static String getCurrentDirectoryPath() {
        return currentDirectoryPath;
    }

    public static String convertToPartial(File file) {
        return TFileHandler.convertToPartial(file.getAbsolutePath());
    }

    public static String convertToPartial(String path) {
        return TFileHandler.removeDirectoryPath(currentDirectoryPath, path);
    }

    public static String removeDirectoryPath(String directory, String path) {
        if (path.substring(0, directory.length()).equals(directory)) {
            return path.substring(directory.length() + 1);
        }
        return null;
    }

    public static String convertToAbsolute(String path) {
        return String.valueOf(currentDirectoryPath) + File.separator + path;
    }

    public static void deleteCurrentDirectory() {
        TFileHandler.deleteDirectory(currentDirectory);
        currentDirectory.delete();
    }

    public static void cleanCurrentDirectory() {
        TFileHandler.deleteDirectory(currentDirectory);
    }

    public static void deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2].isDirectory()) {
                    TFileHandler.deleteDirectory(files[i2]);
                }
                files[i2].delete();
                ++i2;
            }
        }
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        destinationChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        sourceChannel.close();
        destinationChannel.close();
    }

    private static String replace(String word) {
        String result = word.replace(' ', '_').replace(',', '-').replace('\ufffd', 'a').replace('\ufffd', 'e').replace('\ufffd', 'i').replace('\ufffd', 'o').replace('\ufffd', 'u').replace('\ufffd', 'A').replace('\ufffd', 'E').replace('\ufffd', 'I').replace('\ufffd', 'O').replace('\ufffd', 'U').replace("\ufffd", "ny").replace("\ufffd", "NY").toLowerCase();
        return result;
    }

    public static String getFilename(String filePath) {
        String fileName = null;
        int ini = -1;
        int end = filePath.lastIndexOf(46);
        if (ini < end && ini >= -1 && ini < filePath.length() - 1 && end >= 0 && end < filePath.length()) {
            fileName = filePath.substring(ini + 1, end);
        }
        return fileName;
    }

    public static String getExtension(String filePath) {
        String extension = null;
        int i2 = filePath.lastIndexOf(46);
        if (i2 > 0 && i2 < filePath.length() - 1) {
            extension = filePath.substring(i2 + 1).toLowerCase();
        }
        return extension;
    }

    public static File getDefaultImportDirectory() {
        return DEFAULT_IMPORT_DIR;
    }
}

