/*
 * Decompiled with CFR 0.152.
 */
package tico.editor;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import tico.components.TMenuItem;
import tico.components.TToolBarContainer;
import tico.configuration.TLanguage;
import tico.editor.TActionSet;
import tico.editor.TEditor;
import tico.editor.actions.THideToolBarAction;

public class TEditorMenuBar
extends JMenuBar {
    private TEditor editor;
    private TToolBarContainer toolBarContainer;
    private TActionSet actionSet;

    public TEditorMenuBar(TEditor editor, TToolBarContainer toolBarContainer) {
        this.editor = editor;
        this.toolBarContainer = toolBarContainer;
        this.actionSet = editor.getActionSet();
        this.createFileMenu();
        this.createEditMenu();
        this.createViewMenu();
        this.createToolsMenu();
        this.createBoardMenu();
        this.createProjectMenu();
        this.createDynamicToolsMenu();
        this.createHelpMenu();
    }

    private void createFileMenu() {
        JMenu menu = new JMenu(TLanguage.getString("TEditorMenuBar.FILE_MENU"));
        menu.setMnemonic(65);
        TMenuItem menuItem = new TMenuItem(this.actionSet.getAction("proyectNewAction"));
        menuItem.setMnemonic(78);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("proyectNewAndroidAction"));
        menuItem.setMnemonic(68);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 3));
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("proyectOpenAction"));
        menuItem.setMnemonic(65);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("proyectSaveAction"));
        menuItem.setMnemonic(71);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("proyectSaveAsAction"));
        menuItem.setMnemonic(79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, 3));
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("projectPrintAction"));
        menuItem.setMnemonic(80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("proyectImportAction"));
        menuItem.setMnemonic(73);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        menu.add(menuItem);
        JMenu submenu = new JMenu(TLanguage.getString("TEditorMenuBar.EXPORT_MENU"));
        submenu.setMnemonic(69);
        menuItem = new TMenuItem(this.actionSet.getAction("boardExportAction"));
        menuItem.setText(TLanguage.getString("TEditorMenuBar.BOARD"));
        menuItem.setMnemonic(69);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        submenu.add(menuItem);
        submenu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("boardExportPNGAction"));
        menuItem.setText(TLanguage.getString("TEditorMenuBar.TO_PNG"));
        menuItem.setMnemonic(80);
        submenu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("boardExportJPGAction"));
        menuItem.setText(TLanguage.getString("TEditorMenuBar.TO_JPG"));
        menuItem.setMnemonic(74);
        submenu.add(menuItem);
        menu.add(submenu);
        menu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("editorExitAction"));
        menuItem.setMnemonic(83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menu.add(menuItem);
        this.add(menu);
    }

    private void createEditMenu() {
        JMenu menu = new JMenu(TLanguage.getString("TEditorMenuBar.EDIT_MENU"));
        menu.setMnemonic(69);
        TMenuItem menuItem = new TMenuItem(this.actionSet.getAction("undoAction"));
        menuItem.setMnemonic(68);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("redoAction"));
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("cutAction"));
        menuItem.setMnemonic(84);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("copyAction"));
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("pasteAction"));
        menuItem.setMnemonic(80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("deleteAction"));
        menuItem.setMnemonic(66);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("selectAllAction"));
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("editorPreferences"));
        menuItem.setMnemonic(69);
        menu.add(menuItem);
        this.add(menu);
    }

    private void createViewMenu() {
        JMenu menu = new JMenu(TLanguage.getString("TEditorMenuBar.VIEW_MENU"));
        menu.setMnemonic(86);
        JCheckBoxMenuItem cbMenuItem = new JCheckBoxMenuItem(new THideToolBarAction(this.editor, this.toolBarContainer.getToolBar(0)));
        cbMenuItem.setState(true);
        cbMenuItem.setMnemonic(73);
        cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 10));
        menu.add(cbMenuItem);
        cbMenuItem = new JCheckBoxMenuItem(new THideToolBarAction(this.editor, this.toolBarContainer.getToolBar(1)));
        cbMenuItem.setState(true);
        cbMenuItem.setMnemonic(69);
        cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 10));
        menu.add(cbMenuItem);
        cbMenuItem = new JCheckBoxMenuItem(new THideToolBarAction(this.editor, this.toolBarContainer.getToolBar(2)));
        cbMenuItem.setState(true);
        cbMenuItem.setMnemonic(72);
        cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 10));
        menu.add(cbMenuItem);
        cbMenuItem = new JCheckBoxMenuItem(new THideToolBarAction(this.editor, this.toolBarContainer.getToolBar(3)));
        cbMenuItem.setState(true);
        cbMenuItem.setMnemonic(70);
        cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 10));
        menu.add(cbMenuItem);
        cbMenuItem = new JCheckBoxMenuItem(new THideToolBarAction(this.editor, this.toolBarContainer.getToolBar(4)));
        cbMenuItem.setState(true);
        cbMenuItem.setMnemonic(84);
        cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 10));
        menu.add(cbMenuItem);
        cbMenuItem = new JCheckBoxMenuItem(new THideToolBarAction(this.editor, this.toolBarContainer.getToolBar(5)));
        cbMenuItem.setState(true);
        cbMenuItem.setMnemonic(65);
        cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 10));
        menu.add(cbMenuItem);
        this.add(menu);
    }

    private void createToolsMenu() {
        JMenu menu = new JMenu(TLanguage.getString("TEditorMenuBar.TOOLS_MENU"));
        menu.setMnemonic(72);
        TMenuItem menuItem = new TMenuItem(this.actionSet.getAction("selectionHandlerAction"));
        menuItem.setMnemonic(69);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 1));
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("cellHandlerAction"));
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 1));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("controllerCellHandlerAction"));
        menuItem.setMnemonic(78);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 1));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("gridHandlerAction"));
        menuItem.setMnemonic(85);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(85, 1));
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("lineHandlerAction"));
        menuItem.setMnemonic(76);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(76, 1));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("rectangleHandlerAction"));
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(82, 1));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("roundRectHandlerAction"));
        menuItem.setMnemonic(68);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(68, 1));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("ovalHandlerAction"));
        menuItem.setMnemonic(79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 1));
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("textAreaHandlerAction"));
        menuItem.setMnemonic(65);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 1));
        menu.add(menuItem);
        menuItem = new TMenuItem(this.actionSet.getAction("labelHandlerAction"));
        menuItem.setMnemonic(84);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(84, 1));
        menu.add(menuItem);
        this.add(menu);
    }

    private void createBoardMenu() {
        JMenu menu = new JMenu(TLanguage.getString("TEditorMenuBar.BOARD_MENU"));
        menu.setMnemonic(84);
        TMenuItem menuItem = new TMenuItem(this.actionSet.getAction("boardPropertiesAction"));
        menuItem.setMnemonic(82);
        menu.add(menuItem);
        this.add(menu);
    }

    private void createProjectMenu() {
        JMenu menu = new JMenu(TLanguage.getString("TEditorMenuBar.PROJECT_MENU"));
        menu.setMnemonic(80);
        TMenuItem menuItem = new TMenuItem(this.actionSet.getAction("projectPropertiesAction"));
        menuItem.setMnemonic(82);
        menu.add(menuItem);
        this.add(menu);
    }

    private JMenu createValidationMenu() {
        JMenu menu = new JMenu(TLanguage.getString("TEditorMenuBar.VALIDATION_MENU"));
        JMenu submenu = new JMenu(TLanguage.getString("TEditorMenuBar.ADMIN_MENU"));
        TMenuItem menuItem = new TMenuItem(this.actionSet.getAction("usersAdminAction"));
        submenu.add(menuItem);
        submenu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("limitationsAdminAction"));
        submenu.add(menuItem);
        submenu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("rulesAdminAction"));
        submenu.add(menuItem);
        menu.add(submenu);
        menu.add(new JSeparator());
        submenu = new JMenu(TLanguage.getString("TEditorMenuBar.VALIDATE_MENU"));
        menuItem = new TMenuItem(this.actionSet.getAction("boardValidationAction"));
        submenu.add(menuItem);
        submenu.add(new JSeparator());
        menuItem = new TMenuItem(this.actionSet.getAction("projectValidationAction"));
        menuItem.setMnemonic(70);
        submenu.add(menuItem);
        menu.add(submenu);
        return menu;
    }

    private void createDynamicToolsMenu() {
        JMenu menu = new JMenu(TLanguage.getString("TEditorMenuBar.DYNAMIC_MENU"));
        menu.setMnemonic(80);
        TMenuItem menuItem = new TMenuItem(this.actionSet.getAction("galleryManagerAction"));
        menuItem.setMnemonic(82);
        menu.add(menuItem);
        this.add(menu);
    }

    private void createHelpMenu() {
        JMenu menu = new JMenu(TLanguage.getString("TEditorMenuBar.HELP_MENU"));
        menu.setMnemonic(89);
        TMenuItem menuItem = new TMenuItem(this.actionSet.getAction("editorAbout"));
        menuItem.setMnemonic(65);
        menu.add(menuItem);
        this.add(menu);
    }
}

