/*
 * Decompiled with CFR 0.152.
 */
package tico.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.GraphModel;
import tico.board.TBoard;
import tico.board.TBoardConstants;
import tico.board.TBoardModel;
import tico.board.TProject;
import tico.board.events.ProjectChangeEvent;
import tico.board.events.ProjectChangeListener;
import tico.components.TButton;
import tico.components.TOrderList;
import tico.components.TToolBarContainer;
import tico.components.events.OrderChangeEvent;
import tico.components.events.OrderChangeListener;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.editor.TActionSet;
import tico.editor.TBoardContainer;
import tico.editor.TEditorMenuBar;
import tico.editor.TFileHandler;
import tico.editor.actions.TEditorExitAction;
import tico.editor.toolbars.TAlignToolBar;
import tico.editor.toolbars.TEditionToolBar;
import tico.editor.toolbars.TFileToolBar;
import tico.editor.toolbars.TFormatToolBar;
import tico.editor.toolbars.THandlersToolBar;
import tico.editor.toolbars.TTextToolBar;

public class TEditor
extends JFrame {
    private static boolean android_mode = false;
    private static int board_width = 800;
    private static int board_height = 600;
    private static Color board_background_color = Color.WHITE;
    private static Color board_gradient_color = null;
    private static String android_orientation = "free";
    private static String DEFAULT_TITLE = TLanguage.getString("TEditor.EDITOR_WINDOW_TITLE");
    private TProject project;
    private boolean modified = false;
    private File projectFile = null;
    private TOrderList boardList;
    private TOrderList cellOrderList;
    private JPanel boardPanel;
    private TToolBarContainer toolBarContainer;
    private TEditionToolBar editionToolBar;
    private TAlignToolBar alignToolBar;
    private TFileToolBar fileToolBar;
    private TFormatToolBar formatToolBar;
    private THandlersToolBar handlersToolBar;
    private TTextToolBar textToolBar;
    private TActionSet actionSet;
    private Dimension initLocation = new Dimension(100, 100);
    private Dimension initSize = new Dimension(800, 600);

    public TEditor() {
        this((TProject)null);
    }

    public TEditor(TProject project) {
        super(DEFAULT_TITLE);
        this.setDefaultCloseOperation(3);
        this.setWindowAtributes();
        this.getContentPane().setLayout(new BorderLayout());
        this.createActions();
        this.createToolBars();
        this.createMenu();
        this.createBoardEditor();
        this.createWindowListener();
        this.updateProjectButtons();
        if (project != null) {
            this.setProject(project);
        }
        this.setVisible(true);
        TBoardConstants.editor = this;
    }

    protected void setWindowAtributes() {
        this.setIconImage(TResourceManager.getImage("editor-icon-24.png"));
        this.setLocation(this.initLocation.width, this.initLocation.height);
        this.setSize(this.initSize.width, this.initSize.height);
    }

    private void createActions() {
        this.actionSet = new TActionSet(this);
    }

    protected void createToolBars() {
        this.toolBarContainer = new TToolBarContainer();
        this.fileToolBar = new TFileToolBar(this);
        this.editionToolBar = new TEditionToolBar(this);
        this.handlersToolBar = new THandlersToolBar(this);
        this.formatToolBar = new TFormatToolBar(this);
        this.textToolBar = new TTextToolBar(this);
        this.alignToolBar = new TAlignToolBar(this);
        this.toolBarContainer.addToolBar(this.fileToolBar);
        this.toolBarContainer.addToolBar(this.editionToolBar);
        this.toolBarContainer.addToolBar(this.handlersToolBar);
        this.toolBarContainer.addToolBar(this.formatToolBar);
        this.toolBarContainer.addToolBar(this.textToolBar);
        this.toolBarContainer.addToolBar(this.alignToolBar);
        this.getContentPane().add((Component)this.toolBarContainer, "North");
    }

    private void createMenu() {
        this.setJMenuBar(new TEditorMenuBar(this, this.toolBarContainer));
    }

    private void createBoardEditor() {
        JPanel boardListPanel = new JPanel();
        boardListPanel.setLayout(new BorderLayout());
        this.boardList = new TOrderList();
        this.boardList.addOrderChangeListener(new OrderChangeListener(){

            @Override
            public void orderChanged(OrderChangeEvent e2) {
                AttributeMap map = new AttributeMap();
                TEditor.this.getProject().setBoardList(TEditor.this.boardList.getList());
                Hashtable<GraphModel, AttributeMap> nested = new Hashtable<GraphModel, AttributeMap>();
                nested.put(TEditor.this.getCurrentBoard().getModel(), map);
                TEditor.this.getCurrentBoard().getGraphLayoutCache().edit(nested);
            }
        });
        this.boardList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (TEditor.this.getCurrentBoardContainer() != null) {
                    TEditor.this.updateVisibleBoard();
                }
                TEditor.this.updateBoardButtons();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        TButton newBoardButton = new TButton(this.actionSet.getAction("boardNewAction"));
        newBoardButton.setMargin(new Insets(2, 2, 2, 2));
        newBoardButton.setText("");
        newBoardButton.setIcon(TResourceManager.getImageIcon("board-new-16.png"));
        TButton deleteBoardButton = new TButton(this.actionSet.getAction("boardDeleteAction"));
        deleteBoardButton.setMargin(new Insets(2, 2, 2, 2));
        deleteBoardButton.setText("");
        deleteBoardButton.setIcon(TResourceManager.getImageIcon("board-delete-16.png"));
        buttonPanel.add(newBoardButton);
        buttonPanel.add(deleteBoardButton);
        boardListPanel.add((Component)buttonPanel, "North");
        boardListPanel.add((Component)this.boardList, "Center");
        JPanel cellOrderListPane = new JPanel();
        cellOrderListPane.setLayout(new BorderLayout());
        JLabel cellOrderListLabel = new JLabel(TLanguage.getString("TEditor.CELL_ORDER"));
        this.cellOrderList = new TOrderList();
        this.cellOrderList.addOrderChangeListener(new OrderChangeListener(){

            @Override
            public void orderChanged(OrderChangeEvent e2) {
                AttributeMap map = new AttributeMap();
                TBoardConstants.setOrderedCellList(map, TEditor.this.cellOrderList.getList());
                Hashtable<GraphModel, AttributeMap> nested = new Hashtable<GraphModel, AttributeMap>();
                nested.put(TEditor.this.getCurrentBoard().getModel(), map);
                TEditor.this.getCurrentBoard().getGraphLayoutCache().edit(nested);
            }
        });
        this.cellOrderList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                TEditor.this.getCurrentBoard().setSelectionCell(TEditor.this.cellOrderList.getSelectedValue());
            }
        });
        cellOrderListPane.add((Component)cellOrderListLabel, "North");
        cellOrderListPane.add((Component)this.cellOrderList, "Center");
        this.boardPanel = new JPanel();
        this.boardPanel.setLayout(new BorderLayout());
        JScrollPane boardScrollPane = new JScrollPane(this.boardPanel);
        JSplitPane verticalSplitPane = new JSplitPane(0, boardListPanel, cellOrderListPane);
        verticalSplitPane.setResizeWeight(0.8);
        verticalSplitPane.setDividerSize(7);
        verticalSplitPane.setDividerLocation(0.8);
        JSplitPane horizontalSplitPane = new JSplitPane(1, verticalSplitPane, boardScrollPane);
        horizontalSplitPane.setOneTouchExpandable(true);
        horizontalSplitPane.setDividerLocation(200);
        horizontalSplitPane.setDividerSize(7);
        this.getContentPane().add((Component)horizontalSplitPane, "Center");
    }

    private void createWindowListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                new TEditorExitAction(TEditor.this.getEditor()).actionPerformed(null);
            }
        });
    }

    public TEditor getEditor() {
        return this;
    }

    public TProject getProject() {
        return this.project;
    }

    public void setProject(TProject project) {
        if (this.getProject() != null) {
            this.deleteProject();
        }
        if (project.getName() == null) {
            project.setName(TProject.newName());
        }
        this.project = project;
        project.addProjectChangeListener(new ProjectChangeListener(){

            @Override
            public void projectChanged(ProjectChangeEvent e2) {
                if (e2.getChange() == ProjectChangeEvent.BOARD_ADDED) {
                    TEditor.this.addBoard(e2.getChangedBoard());
                } else if (e2.getChange() == ProjectChangeEvent.BOARD_REMOVED) {
                    TEditor.this.removeBoard(e2.getChangedBoard());
                } else if (e2.getChange() == ProjectChangeEvent.NAME_CHANGED) {
                    TEditor.this.updateTitle();
                }
                TEditor.this.setModified(true);
            }
        });
        int i2 = 0;
        while (i2 < project.getBoardList().size()) {
            this.addBoard((TBoard)project.getBoardList().get(i2));
            ++i2;
        }
        this.setModified(false);
        this.updateProjectButtons();
    }

    public void deleteProject() {
        if (this.project == null) {
            return;
        }
        ArrayList list = (ArrayList)this.project.getBoardList().clone();
        int i2 = 0;
        while (i2 < list.size()) {
            this.project.removeBoard((TBoard)list.get(i2));
            ++i2;
        }
        TFileHandler.cleanCurrentDirectory();
        this.project = null;
        this.updateTitle();
        this.updateProjectButtons();
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.updateTitle();
    }

    public boolean isModified() {
        return this.modified;
    }

    public TBoardContainer getCurrentBoardContainer() {
        return (TBoardContainer)this.boardList.getSelectedValue();
    }

    public TBoard getCurrentBoard() {
        if (this.getCurrentBoardContainer() == null) {
            return null;
        }
        return this.getCurrentBoardContainer().getBoard();
    }

    public void removeCurrentBoard() {
        if (this.getCurrentBoard() != null) {
            this.project.removeBoard(this.getCurrentBoard());
        }
    }

    private void addBoard(TBoard board) {
        this.setModified(true);
        TBoardContainer newBoardContainer = new TBoardContainer(this, board);
        this.boardList.addElement(newBoardContainer);
        this.updateVisibleBoard();
    }

    private void removeBoard(TBoard board) {
        this.setModified(true);
        int boardContainerIndex = -1;
        int i2 = 0;
        while (i2 < this.boardList.getList().size() && boardContainerIndex == -1) {
            if (((TBoardContainer)this.boardList.getList().get(i2)).getBoard().equals(board)) {
                boardContainerIndex = i2;
            }
            ++i2;
        }
        if (boardContainerIndex != -1) {
            this.boardPanel.remove((Component)this.boardList.getList().get(boardContainerIndex));
            this.boardList.removeElement((Component)this.boardList.getList().get(boardContainerIndex));
            if (boardContainerIndex < this.boardList.getList().size()) {
                this.boardList.setSelectedIndex(boardContainerIndex);
            } else if (boardContainerIndex > 0) {
                this.boardList.setSelectedIndex(boardContainerIndex - 1);
            }
            this.updateVisibleBoard();
        }
    }

    public TBoardContainer getBoardContainer(int index) {
        return (TBoardContainer)this.boardList.getList().get(index);
    }

    public int getBoardContainerCount() {
        return this.boardList.getList().size();
    }

    private void updateVisibleBoard() {
        ArrayList list = this.boardList.getList();
        int i2 = 0;
        while (i2 < list.size()) {
            this.boardPanel.remove((TBoardContainer)list.get(i2));
            ++i2;
        }
        if (this.getCurrentBoardContainer() != null) {
            this.boardPanel.add((Component)this.getCurrentBoardContainer(), "Center");
        }
        TBoardConstants.currentBoard = this.getCurrentBoard();
        this.boardPanel.updateUI();
        this.updateCellOrderList();
    }

    public TActionSet getActionSet() {
        return this.actionSet;
    }

    public AttributeMap getCurrentAttributes() {
        AttributeMap map = new AttributeMap();
        map.applyMap(this.formatToolBar.getAttributes());
        map.applyMap(this.textToolBar.getAttributes());
        return map;
    }

    public void updateTitle() {
        String title = DEFAULT_TITLE;
        if (TEditor.get_android_mode()) {
            title = String.valueOf(title) + " ANDROID";
        }
        if (this.getProject() != null) {
            title = String.valueOf(title) + " - " + this.getProject().getName();
            if (this.isModified()) {
                title = String.valueOf(title) + " *";
            }
        }
        this.setTitle(title);
    }

    public void updateToolBar() {
        this.handlersToolBar.updateHandlers();
    }

    public void updateUI() {
        this.boardList.updateUI();
        this.boardPanel.updateUI();
    }

    public void updateProjectButtons() {
        boolean projectExists = this.project != null;
        this.actionSet.getAction("boardNewAction").setEnabled(projectExists);
        this.actionSet.getAction("proyectSaveAction").setEnabled(projectExists);
        this.actionSet.getAction("proyectSaveAsAction").setEnabled(projectExists);
        this.actionSet.getAction("proyectImportAction").setEnabled(projectExists);
        this.actionSet.getAction("projectPropertiesAction").setEnabled(projectExists);
        this.actionSet.getAction("projectValidationAction").setEnabled(projectExists);
        this.boardList.setEnabled(projectExists);
        this.cellOrderList.setEnabled(projectExists);
        this.updateBoardButtons();
    }

    public void updateBoardButtons() {
        boolean boardExists = this.getCurrentBoard() != null;
        this.actionSet.getAction("selectionHandlerAction").setEnabled(boardExists);
        this.actionSet.getAction("cellHandlerAction").setEnabled(boardExists);
        this.actionSet.getAction("controllerCellHandlerAction").setEnabled(boardExists);
        this.actionSet.getAction("gridHandlerAction").setEnabled(boardExists);
        this.actionSet.getAction("textAreaHandlerAction").setEnabled(boardExists);
        this.actionSet.getAction("labelHandlerAction").setEnabled(boardExists);
        this.actionSet.getAction("rectangleHandlerAction").setEnabled(boardExists);
        this.actionSet.getAction("roundRectHandlerAction").setEnabled(boardExists);
        this.actionSet.getAction("ovalHandlerAction").setEnabled(boardExists);
        this.actionSet.getAction("lineHandlerAction").setEnabled(boardExists);
        this.formatToolBar.updateComponents();
        this.textToolBar.updateComponents();
        this.actionSet.getAction("selectAllAction").setEnabled(boardExists);
        this.actionSet.getAction("pasteAction").setEnabled(boardExists);
        this.actionSet.getAction("projectPrintAction").setEnabled(boardExists);
        this.actionSet.getAction("boardPropertiesAction").setEnabled(boardExists);
        this.actionSet.getAction("boardDeleteAction").setEnabled(boardExists);
        this.actionSet.getAction("boardExportAction").setEnabled(boardExists);
        this.actionSet.getAction("boardExportPNGAction").setEnabled(boardExists);
        this.actionSet.getAction("boardExportJPGAction").setEnabled(boardExists);
        this.actionSet.getAction("boardValidationAction").setEnabled(boardExists);
        this.updateSelectionButtons();
        this.updateHistoryButtons();
    }

    public void updateHistoryButtons() {
        if (this.getCurrentBoard() != null) {
            this.actionSet.getAction("undoAction").setEnabled(this.getCurrentBoardContainer().getUndoManager().canUndo(this.getCurrentBoard().getGraphLayoutCache()));
            this.actionSet.getAction("redoAction").setEnabled(this.getCurrentBoardContainer().getUndoManager().canRedo(this.getCurrentBoard().getGraphLayoutCache()));
            this.formatToolBar.updateComponents();
            this.textToolBar.updateComponents();
        } else {
            this.actionSet.getAction("undoAction").setEnabled(false);
            this.actionSet.getAction("redoAction").setEnabled(false);
        }
    }

    public void updateCellOrderList() {
        TBoard board = this.getCurrentBoard();
        if (board != null) {
            Object selectedObject = this.cellOrderList.getSelectedValue();
            this.cellOrderList.setList(TBoardConstants.getOrderedCellList(((TBoardModel)this.getCurrentBoard().getModel()).getAttributes()));
            this.cellOrderList.setSelectedValue(selectedObject);
        }
    }

    public void changeToWaitingCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void restoreCursor() {
        Cursor cursorBar = new Cursor(0);
        this.setCursor(cursorBar);
    }

    public void updateSelectionButtons() {
        boolean cutCopyActionsEnabled = false;
        boolean alignActionsEnabled = false;
        boolean gapActionsEnabled = false;
        if (this.getCurrentBoard() != null) {
            int selectionCount = this.getCurrentBoard().getSelectionCount();
            cutCopyActionsEnabled = selectionCount > 0;
            alignActionsEnabled = selectionCount > 1;
            gapActionsEnabled = selectionCount > 2;
        }
        this.actionSet.getAction("alignBottomAction").setEnabled(alignActionsEnabled);
        this.actionSet.getAction("alignTopAction").setEnabled(alignActionsEnabled);
        this.actionSet.getAction("alignLeftAction").setEnabled(alignActionsEnabled);
        this.actionSet.getAction("alignRightAction").setEnabled(alignActionsEnabled);
        this.actionSet.getAction("alignHorizontalAction").setEnabled(alignActionsEnabled);
        this.actionSet.getAction("alignVerticalAction").setEnabled(alignActionsEnabled);
        this.actionSet.getAction("fitWidthAction").setEnabled(alignActionsEnabled);
        this.actionSet.getAction("fitHeightAction").setEnabled(alignActionsEnabled);
        this.actionSet.getAction("horizontalGapAction").setEnabled(gapActionsEnabled);
        this.actionSet.getAction("verticalGapAction").setEnabled(gapActionsEnabled);
        this.actionSet.getAction("frontAction").setEnabled(cutCopyActionsEnabled);
        this.actionSet.getAction("backAction").setEnabled(cutCopyActionsEnabled);
        this.actionSet.getAction("cutAction").setEnabled(cutCopyActionsEnabled);
        this.actionSet.getAction("copyAction").setEnabled(cutCopyActionsEnabled);
        this.actionSet.getAction("deleteAction").setEnabled(cutCopyActionsEnabled);
        this.formatToolBar.updateComponents();
        this.textToolBar.updateComponents();
    }

    public static void set_board_width(int width) {
        board_width = width;
    }

    public static int get_board_width() {
        return board_width;
    }

    public static void set_board_height(int height) {
        board_height = height;
    }

    public static int get_board_height() {
        return board_height;
    }

    public static void set_board_background_color(Color color) {
        board_background_color = color;
    }

    public static Color get_board_background_color() {
        return board_background_color;
    }

    public static void set_board_gradient_color(Color color) {
        board_gradient_color = color;
    }

    public static Color get_board_gradient_color() {
        return board_gradient_color;
    }

    public static void set_android_mode(boolean mode) {
        android_mode = mode;
    }

    public static boolean get_android_mode() {
        return android_mode;
    }

    public static void set_android_orientation(String orientation) {
        android_orientation = orientation;
    }

    public static String get_android_orientation() {
        return android_orientation;
    }
}

