/*
 * Decompiled with CFR 0.152.
 */
package tico.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphLayoutCacheListener;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoard;
import tico.board.TBoardConstants;
import tico.board.TBoardModel;
import tico.board.TBoardUndoManager;
import tico.board.components.TComponent;
import tico.editor.TEditor;
import tico.editor.dialogs.TComponentDialogFactory;
import tico.editor.handler.TBasicMarqueeHandler;

public class TBoardContainer
extends JPanel
implements GraphSelectionListener,
GraphModelListener,
GraphLayoutCacheListener,
PropertyChangeListener,
Printable {
    private TBoard board;
    private TEditor editor;
    private TBoardUndoManager undoManager;
    protected TComponentDialogFactory componentDialogFactory;

    public TBoardContainer(TEditor editor, TBoard board) {
        this.editor = editor;
        this.board = board;
        this.setComponentDialogFactory(new TComponentDialogFactory(this));
        board.setMarqueeHandler(new TBasicMarqueeHandler(this));
        this.setLayout(new BorderLayout());
        this.add((Component)board, "Center");
        this.registerListeners();
    }

    public void resetMarqueeHandler() {
        this.board.setMarqueeHandler(new TBasicMarqueeHandler(this));
    }

    @Override
    public String toString() {
        if (this.board != null) {
            return this.board.getBoardName();
        }
        return null;
    }

    public TBoard getBoard() {
        return this.board;
    }

    private void registerListeners() {
        if (this.board != null) {
            this.board.getSelectionModel().addGraphSelectionListener(this);
            this.board.getModel().addGraphModelListener(this);
            this.board.getGraphLayoutCache().addGraphLayoutCacheListener(this);
            this.board.addPropertyChangeListener(this);
            this.undoManager = new TBoardUndoManager();
            this.board.getModel().addUndoableEditListener(this.undoManager);
        }
    }

    public TEditor getEditor() {
        return this.editor;
    }

    public void setComponentDialogFactory(TComponentDialogFactory factory) {
        this.componentDialogFactory = factory;
    }

    public TComponentDialogFactory getComponentDialogFactory() {
        return this.componentDialogFactory;
    }

    public TBoardUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void resetUndoManager() {
        this.undoManager.discardAllEdits();
    }

    @Override
    public void valueChanged(GraphSelectionEvent e2) {
        this.editor.updateSelectionButtons();
    }

    @Override
    public void graphChanged(GraphModelEvent e2) {
        Object[] removed;
        this.editor.updateHistoryButtons();
        boolean updateCellList = false;
        Map attributes = e2.getChange().getAttributes();
        if (attributes != null) {
            Map modelAttributes = (Map)attributes.get(this.getBoard().getModel());
            if (modelAttributes != null && modelAttributes.containsKey("orderedCellList")) {
                updateCellList = true;
            }
            for (Map.Entry entry : attributes.entrySet()) {
                if (!(entry.getKey() instanceof TComponent)) continue;
                TComponent component = (TComponent)entry.getKey();
                AttributeMap componentAttributes = (AttributeMap)entry.getValue();
                if (!TBoardConstants.isBrowseable(component.getAttributes()) || !componentAttributes.containsKey("id")) continue;
                updateCellList = true;
            }
        }
        if ((removed = e2.getChange().getRemoved()) != null) {
            int i2 = 0;
            while (i2 < removed.length && !updateCellList) {
                if (TBoardConstants.isBrowseable(((TComponent)removed[i2]).getAttributes())) {
                    updateCellList = true;
                }
                ++i2;
            }
        }
        if (updateCellList) {
            this.editor.updateCellOrderList();
        }
        this.editor.updateUI();
    }

    @Override
    public void graphLayoutCacheChanged(GraphLayoutCacheEvent e2) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "marquee") {
            this.editor.updateToolBar();
        }
        if (evt.getPropertyName().equals("transferHandler")) {
            this.board.setMinimumSize(TBoardConstants.getSize(((TBoardModel)this.board.getModel()).getAttributes()));
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        double scaleHeight;
        TBoard printBoard = this.getBoard();
        Dimension bounds = TBoardConstants.getSize(printBoard.getAttributes(printBoard.getModel()));
        Graphics2D g2 = (Graphics2D)graphics;
        double scaleWidth = pageFormat.getImageableWidth() / bounds.getWidth();
        if (scaleWidth > (scaleHeight = pageFormat.getImageableHeight() / bounds.getHeight())) {
            scaleWidth = scaleHeight;
        } else {
            scaleHeight = scaleWidth;
        }
        g2.scale(scaleWidth, scaleHeight);
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        RepaintManager currentManager = RepaintManager.currentManager(printBoard);
        currentManager.setDoubleBufferingEnabled(false);
        printBoard.paint(g2);
        g2.translate(0.0, 0.0);
        g2.drawString(printBoard.toString(), 30, 38);
        currentManager.setDoubleBufferingEnabled(true);
        return 0;
    }
}

