/*
 * Decompiled with CFR 0.152.
 */
package tico.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import tico.configuration.TLanguage;

public class TSetup {
    private static String CONFIGURATION_FILE_PATH = "conf" + File.separator + "tico.conf";
    private static File CONFIGURATION_FILE = new File(CONFIGURATION_FILE_PATH);
    private static String language = "Espa\u00f1ol";
    private static String editorHomeDirectory = "";
    private static String interpreterHomeDirectory = "";
    private static int boardHeightAndroid = 400;
    private static int boardWidthAndroid = 400;
    private static String orientationAndroid = "free";

    public static void load() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(CONFIGURATION_FILE);
        Element preferencesElement = doc.getDocumentElement();
        if (preferencesElement.getTagName().equals("preferences")) {
            String orientation;
            NodeList orientationNodeList;
            NodeList widthNodeList;
            NodeList heightNodeList;
            String interpreterHomeDirectory;
            NodeList interpreterNodeList;
            String editorHomeDirectory;
            NodeList editorNodeList;
            String language;
            NodeList languageNodeList = preferencesElement.getElementsByTagName("language");
            if (languageNodeList.getLength() > 0 && (language = languageNodeList.item(0).getChildNodes().item(0).getNodeValue()) != null && TLanguage.languageExists(language)) {
                TSetup.setLanguage(language);
            }
            if ((editorNodeList = preferencesElement.getElementsByTagName("editorHomeDirectory")).getLength() > 0 && (editorHomeDirectory = editorNodeList.item(0).getChildNodes().item(0).getNodeValue()) != null && TSetup.directoryExists(editorHomeDirectory)) {
                TSetup.setEditorHome(editorHomeDirectory);
            }
            if ((interpreterNodeList = preferencesElement.getElementsByTagName("interpreterHomeDirectory")).getLength() > 0 && (interpreterHomeDirectory = interpreterNodeList.item(0).getChildNodes().item(0).getNodeValue()) != null && TSetup.directoryExists(interpreterHomeDirectory)) {
                TSetup.setInterpreterHome(interpreterHomeDirectory);
            }
            if ((heightNodeList = preferencesElement.getElementsByTagName("boardHeightAndroid")).getLength() > 0) {
                try {
                    boardHeightAndroid = Integer.parseInt(heightNodeList.item(0).getChildNodes().item(0).getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((widthNodeList = preferencesElement.getElementsByTagName("boardWidthAndroid")).getLength() > 0) {
                try {
                    boardWidthAndroid = Integer.parseInt(widthNodeList.item(0).getChildNodes().item(0).getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((orientationNodeList = preferencesElement.getElementsByTagName("orientationAndroid")).getLength() > 0 && (orientation = orientationNodeList.item(0).getChildNodes().item(0).getNodeValue()) != null) {
                TSetup.setOrientation(orientation);
            }
        }
    }

    public static void save() throws ParserConfigurationException, IOException, TransformerException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document doc = domBuilder.newDocument();
        Element projectElement = doc.createElement("preferences");
        Element languageElement = doc.createElement("language");
        languageElement.appendChild(doc.createTextNode(TSetup.getLanguage()));
        projectElement.appendChild(languageElement);
        if (!TSetup.getEditorHome().equals("")) {
            Element editorHomeElement = doc.createElement("editorHomeDirectory");
            editorHomeElement.appendChild(doc.createTextNode(TSetup.getEditorHome()));
            projectElement.appendChild(editorHomeElement);
        }
        if (!TSetup.getInterpreterHome().equals("")) {
            Element interpreterHomeElement = doc.createElement("interpreterHomeDirectory");
            interpreterHomeElement.appendChild(doc.createTextNode(TSetup.getInterpreterHome()));
            projectElement.appendChild(interpreterHomeElement);
        }
        if (TSetup.getBoardHeight() > 0) {
            Element boardHeightElement = doc.createElement("boardHeightAndroid");
            boardHeightElement.appendChild(doc.createTextNode(Integer.toString(TSetup.getBoardHeight())));
            projectElement.appendChild(boardHeightElement);
        }
        if (TSetup.getBoardWidth() > 0) {
            Element boardWidthElement = doc.createElement("boardWidthAndroid");
            boardWidthElement.appendChild(doc.createTextNode(Integer.toString(TSetup.getBoardWidth())));
            projectElement.appendChild(boardWidthElement);
        }
        if (!TSetup.getOrientation().equals("")) {
            Element orientationElement = doc.createElement("orientationAndroid");
            orientationElement.appendChild(doc.createTextNode(TSetup.getOrientation()));
            projectElement.appendChild(orientationElement);
        }
        doc.appendChild(projectElement);
        BufferedWriter bufferWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(CONFIGURATION_FILE), "UTF-8"));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(bufferWriter);
        transformer.transform(source, result);
        bufferWriter.close();
    }

    public static String getLanguage() {
        return language;
    }

    public static String getLanguageCode() {
        if (language.equals("Espa\u00f1ol") || language.equals("Castellano")) {
            return "es";
        }
        if (language.equals("Euskara") || language.equals("Euskera")) {
            return "eu";
        }
        if (language.equals("English")) {
            return "en";
        }
        if (language.equals("Fran\u00e7ais")) {
            return "fr";
        }
        if (language.equals("Catal\u00e0")) {
            return "ca";
        }
        if (language.equals("Portugues")) {
            return "pt";
        }
        return "en";
    }

    public static void setLanguage(String language) {
        TSetup.language = language;
    }

    public static String getEditorHome() {
        return editorHomeDirectory;
    }

    public static void setEditorHome(String pathEditor) {
        editorHomeDirectory = pathEditor;
    }

    public static String getInterpreterHome() {
        return interpreterHomeDirectory;
    }

    public static void setInterpreterHome(String pathInterpreter) {
        interpreterHomeDirectory = pathInterpreter;
    }

    public static String getOrientation() {
        return orientationAndroid;
    }

    public static void setOrientation(String orientation) {
        orientationAndroid = orientation;
    }

    public static int getBoardHeight() {
        return boardHeightAndroid;
    }

    public static void setBoardHeight(int height) {
        boardHeightAndroid = height;
    }

    public static int getBoardWidth() {
        return boardWidthAndroid;
    }

    public static void setBoardWidth(int width) {
        boardWidthAndroid = width;
    }

    private static boolean directoryExists(String directoryPath) {
        File file = new File(directoryPath);
        return file.exists();
    }
}

