/*
 * Decompiled with CFR 0.152.
 */
package tico.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import tico.components.resources.TFileUtils;
import tico.configuration.TResourceBundle;
import tico.configuration.TSetup;

public class TLanguage {
    private static String LANGUAGE_DIRECTORY = "lang";
    protected static String currentLanguage = TSetup.getLanguage();
    protected static Map languagesMap = TLanguage.getLanguages();
    protected static TResourceBundle LANGUAGE_BUNDLE = null;

    public static void initLanguage(String language) throws IOException {
        languagesMap = TLanguage.getLanguages();
        if (languagesMap == null || languagesMap.isEmpty()) {
            throw new FileNotFoundException();
        }
        currentLanguage = language;
        if (currentLanguage == null || !languagesMap.containsKey(currentLanguage)) {
            Iterator languagesIterator = languagesMap.entrySet().iterator();
            Map.Entry languageEntry = languagesIterator.next();
            currentLanguage = (String)languageEntry.getKey();
        }
        FileInputStream i2 = new FileInputStream((File)languagesMap.get(currentLanguage));
        LANGUAGE_BUNDLE = new TResourceBundle(i2);
    }

    public static boolean languageExists(String language) {
        Map languageMap = TLanguage.getLanguages();
        return languageMap.containsKey(language);
    }

    public static Map getLanguages() {
        Hashtable<String, File> languagesMap = new Hashtable<String, File>();
        File languageDirectory = new File(LANGUAGE_DIRECTORY);
        File[] fileList = languageDirectory.listFiles();
        int i2 = 0;
        while (i2 < fileList.length) {
            try {
                if (TFileUtils.getExtension(fileList[i2]).equals("lang")) {
                    TResourceBundle currentLanguageBundle = new TResourceBundle(new FileInputStream(fileList[i2]));
                    languagesMap.put(currentLanguageBundle.getString("LANG_NAME"), fileList[i2]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i2;
        }
        return languagesMap;
    }

    public static String getString(String key) {
        try {
            return LANGUAGE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e2) {
            return String.valueOf('\u00a1') + key + '!';
        }
        catch (NullPointerException e3) {
            return String.valueOf('\u00a1') + key + '!';
        }
    }

    public static String getString(String language, String key) {
        String keyValue = null;
        File languageDirectory = new File(LANGUAGE_DIRECTORY);
        File[] fileList = languageDirectory.listFiles();
        int i2 = 0;
        while (i2 < fileList.length) {
            try {
                TResourceBundle currentLanguageBundle;
                if (TFileUtils.getExtension(fileList[i2]).equals("lang") && language.equals((currentLanguageBundle = new TResourceBundle(new FileInputStream(fileList[i2]))).getString("LANG_NAME"))) {
                    keyValue = currentLanguageBundle.getString(key);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i2;
        }
        return keyValue;
    }
}

