/*
 * Decompiled with CFR 0.152.
 */
package tico.components.resources;

import java.io.File;

public class TFileUtils {
    public static final String JPEG = "jpeg";
    public static final String JPG = "jpg";
    public static final String GIF = "gif";
    public static final String PNG = "png";
    public static final String MP3 = "mp3";
    public static final String WAV = "wav";
    public static final String MID = "mid";
    public static final String MIDI = "midi";
    public static final String AVI = "avi";
    public static final String MPG = "mpg";
    public static final String MPEG = "mpeg";
    public static final String WMV = "wmv";
    public static final String FLV = "flv";
    public static final String TCO = "tco";
    public static final String TCOA = "tcoa";
    public static final String BRD = "brd";
    public static final String XML = "xml";
    public static final String GP3 = "3gp";
    public static final String MP4 = "mp4";

    public static String getFilename(String filePath) {
        int end;
        String fileName = null;
        int ini = filePath.lastIndexOf(File.separator);
        if (ini < (end = filePath.lastIndexOf(46)) && ini >= -1 && ini < filePath.length() - 1 && end >= 0 && end < filePath.length()) {
            fileName = filePath.substring(ini + 1, end);
        }
        return fileName;
    }

    public static String getFilename(File file) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.getFilename(filePath);
    }

    public static String getExtension(String filePath) {
        String extension = null;
        int i2 = filePath.lastIndexOf(46);
        if (i2 > 0 && i2 < filePath.length() - 1) {
            extension = filePath.substring(i2 + 1).toLowerCase();
        }
        return extension;
    }

    public static String getExtension(File file) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.getExtension(filePath);
    }

    public static String setExtension(String filePath, String extension) {
        int end;
        String fileExtension = TFileUtils.getExtension(filePath);
        if (fileExtension == null) {
            return String.valueOf(filePath) + "." + extension.toLowerCase();
        }
        if (!fileExtension.equals(extension) && (end = filePath.lastIndexOf(46)) >= 0 && end < filePath.length()) {
            return String.valueOf(filePath.substring(0, end)) + "." + extension.toLowerCase();
        }
        return filePath;
    }

    public static String setExtension(File file, String extension) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.setExtension(filePath, extension);
    }

    public static boolean isImageFile(String filePath) {
        String extension = TFileUtils.getExtension(filePath);
        return extension != null && (extension.equals(GIF) || extension.equals(JPEG) || extension.equals(JPG) || extension.equals(PNG));
    }

    public static boolean isImageFile(File file) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.isImageFile(filePath);
    }

    public static boolean isJAIRequired(String filePath) {
        String ext = TFileUtils.getExtension(filePath);
        return !ext.equals(GIF) && !ext.equals(JPG) && !ext.equals(JPEG) && !ext.equals(PNG);
    }

    public static boolean isJAIRequired(File file) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.isJAIRequired(filePath);
    }

    public static boolean isSoundFile(String filePath) {
        String extension = TFileUtils.getExtension(filePath);
        return extension != null && (extension.equals(MP3) || extension.equals(WAV) || extension.equals(MID) || extension.equals(MIDI));
    }

    public static boolean isSoundFile(File file) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.isSoundFile(filePath);
    }

    public static boolean isVideoFile(String filePath) {
        String extension = TFileUtils.getExtension(filePath);
        return extension != null && (extension.equals(AVI) || extension.equals(MPG) || extension.equals(MPEG) || extension.equals(WMV) || extension.equals(FLV) || extension.equals(MP4) || extension.equals(GP3));
    }

    public static boolean isVideoFile(File file) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.isVideoFile(filePath);
    }

    public static boolean isProjectFile(String filePath) {
        String extension = TFileUtils.getExtension(filePath);
        return extension != null && extension.equals(TCO);
    }

    public static boolean isProjectAndroidFile(String filePath) {
        String extension = TFileUtils.getExtension(filePath);
        return extension != null && extension.equals(TCOA);
    }

    public static boolean isProjectFile(File file) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.isProjectFile(filePath);
    }

    public static boolean isProjectAndroidFile(File file) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.isProjectAndroidFile(filePath);
    }

    public static boolean isBoardFile(String filePath) {
        String extension = TFileUtils.getExtension(filePath);
        return extension != null && extension.equals(BRD);
    }

    public static boolean isBoardFile(File file) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.isBoardFile(filePath);
    }

    public static boolean isTicoFile(String filePath) {
        String extension = TFileUtils.getExtension(filePath);
        return extension != null && (extension.equals(TCO) || extension.equals(BRD));
    }

    public static boolean isTicoFile(File file) {
        String filePath = file.getAbsolutePath();
        return TFileUtils.isTicoFile(filePath);
    }
}

