/*
 * Decompiled with CFR 0.152.
 */
package tico.components.resources;

import java.awt.Image;
import java.net.URL;
import java.util.Stack;
import javax.swing.ImageIcon;

public class ImageLoader {
    protected static Stack searchPath = new Stack();

    static {
        ImageLoader.pushSearchPath("/tico/components/resources");
    }

    public static Image getImage(String imageName) {
        return ImageLoader.getImageIcon(imageName).getImage();
    }

    public static ImageIcon getImageIcon(String imageName) {
        return ImageLoader.getImageIcon(searchPath.size() - 1, imageName);
    }

    public static ImageIcon getImageIcon(int searchPathIndex, String imageName) {
        if (imageName == null) {
            return null;
        }
        if (searchPathIndex < searchPath.size() && searchPathIndex >= 0) {
            URL url = ImageLoader.class.getResource(String.valueOf((String)searchPath.get(searchPathIndex)) + imageName);
            if (url != null) {
                return new ImageIcon(url);
            }
            return ImageLoader.getImageIcon(searchPathIndex - 1, imageName);
        }
        return null;
    }

    public static void pushSearchPath(String path) {
        if (path == null) {
            return;
        }
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        searchPath.push(path);
    }

    public static void removeSearchPath(int index) {
        searchPath.remove(index);
    }

    public static void popSearchPath() {
        searchPath.pop();
    }
}

