/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TTextField;
import tico.components.resources.TFileUtils;
import tico.components.resources.VideoFilter;
import tico.configuration.TLanguage;
import tico.editor.TFileHandler;

public class TVideoChooser
extends JPanel {
    private static final String DEFAULT_TITLE = TLanguage.getString("TVideoChooser.TITLE");
    private JPanel videoFilePanel;
    private JPanel videoURLPanel;
    private String videoFilePath;
    private String videoFileURL;
    private TTextField videoFileTextField;
    private TTextField videoURLTextField;
    private JPanel buttonPanel;
    private TButton clearVideoButton;
    private TButton selectVideoFileButton;
    private TButton insertVideoURLButton;
    private static File defaultDirectory = null;

    public TVideoChooser() {
        this(DEFAULT_TITLE);
    }

    public TVideoChooser(String title) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), title));
        this.createVideoFilePanel();
        this.createVideoURLPanel();
        this.createButtonPanel();
        this.updateComponents();
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)this.videoFilePanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        c2.gridx = 0;
        c2.gridy = 1;
        this.add((Component)this.videoURLPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        c2.gridx = 0;
        c2.gridy = 2;
        this.add((Component)this.buttonPanel, c2);
    }

    private void createVideoFilePanel() {
        this.videoFilePanel = new JPanel();
        this.videoFilePanel.setLayout(new FlowLayout());
        JLabel textFileLabel = new JLabel(TLanguage.getString("TVideoChooser.NAME"));
        this.videoFilePanel.add(textFileLabel);
        this.videoFileTextField = new TTextField();
        this.videoFileTextField.setColumns(20);
        this.videoFileTextField.setEditable(false);
        this.videoFilePanel.add(this.videoFileTextField);
        this.selectVideoFileButton = new TButton(TLanguage.getString("TVideoChooser.BUTTON_SELECT"));
        this.selectVideoFileButton.addActionListener(new ChooseVideoButtonListener());
        this.videoFilePanel.add(this.selectVideoFileButton);
    }

    private void createVideoURLPanel() {
        this.videoURLPanel = new JPanel();
        this.videoURLPanel.setLayout(new FlowLayout());
        JLabel textURLLabel = new JLabel(TLanguage.getString("TVideoChooser.URL"));
        this.videoURLPanel.add(textURLLabel);
        this.videoURLTextField = new TTextField();
        this.videoURLTextField.setColumns(20);
        this.videoURLTextField.setEditable(false);
        this.videoURLPanel.add(this.videoURLTextField);
        this.insertVideoURLButton = new TButton(TLanguage.getString("TVideoChooser.BUTTON_INSERT_URL"));
        this.insertVideoURLButton.addActionListener(new ChooseURLVideoButtonListener());
        this.videoURLPanel.add(this.insertVideoURLButton);
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.clearVideoButton = new TButton(new AbstractAction(TLanguage.getString("TVideoChooser.BUTTON_CLEAR")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TVideoChooser.this.setVideoFilePath(null);
                TVideoChooser.this.setVideoFileURL(null);
                TVideoChooser.this.selectVideoFileButton.setEnabled(true);
                TVideoChooser.this.insertVideoURLButton.setEnabled(true);
            }
        });
        this.buttonPanel.add(this.clearVideoButton);
    }

    public void updateComponents() {
        if (this.videoFilePath != null) {
            this.clearVideoButton.setEnabled(true);
            this.videoFileTextField.setText(String.valueOf(TFileUtils.getFilename(this.videoFilePath.toString())) + "." + TFileUtils.getExtension(this.videoFilePath.toString()));
            this.videoFileTextField.setCaretPosition(0);
            this.insertVideoURLButton.setEnabled(false);
        } else {
            this.videoFileTextField.setText("");
        }
        if (this.videoFileURL != null) {
            this.clearVideoButton.setEnabled(true);
            this.videoURLTextField.setText(this.videoFileURL);
            this.videoURLTextField.setCaretPosition(0);
            this.selectVideoFileButton.setEnabled(false);
        } else {
            this.videoURLTextField.setText("");
        }
        if (this.videoFilePath == null && this.videoFileURL == null) {
            this.clearVideoButton.setEnabled(false);
        }
    }

    public String getVideoFilePath() {
        return this.videoFilePath;
    }

    public void setVideoFilePath(String videoFilePath) {
        this.videoFilePath = videoFilePath;
        this.updateComponents();
    }

    public String getVideoFileURL() {
        return this.videoFileURL;
    }

    public void setVideoFileURL(String videoFileURL) {
        this.videoFileURL = videoFileURL;
        this.updateComponents();
    }

    private class ChooseURLVideoButtonListener
    implements ActionListener {
        JDialog insertURL;
        JTextField textURL;

        private ChooseURLVideoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.insertURL = new JDialog();
            this.insertURL.setTitle(TLanguage.getString("TVideoChooser.INSERT_URL_VIDEO"));
            this.insertURL.setLocationRelativeTo(((Component)e2.getSource()).getParent());
            this.insertURL.setModal(true);
            this.insertURL.setLayout(new GridBagLayout());
            GridBagConstraints c2 = new GridBagConstraints();
            JLabel labelURL = new JLabel(TLanguage.getString("TVideoChooser.URL"));
            this.textURL = new JTextField(40);
            this.textURL.setText("http://");
            TButton acceptButton = new TButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    ChooseURLVideoButtonListener.this.insertURL.dispose();
                    String url = ChooseURLVideoButtonListener.this.textURL.getText();
                    if (url != null && !url.equals("") && !url.equals("http://")) {
                        TVideoChooser.this.setVideoFileURL(ChooseURLVideoButtonListener.this.textURL.getText());
                    }
                }
            });
            acceptButton.setText(TLanguage.getString("TVideoChooser.INSERT_URL_ACCEPT"));
            c2.anchor = 10;
            c2.insets = new Insets(10, 10, 10, 10);
            c2.gridx = 0;
            c2.gridy = 0;
            this.insertURL.add((Component)labelURL, c2);
            c2.gridx = 1;
            c2.gridy = 0;
            this.insertURL.add((Component)this.textURL, c2);
            c2.gridx = 0;
            c2.gridy = 1;
            c2.gridwidth = 2;
            this.insertURL.add((Component)acceptButton, c2);
            this.insertURL.setDefaultCloseOperation(2);
            this.insertURL.pack();
            this.insertURL.setVisible(true);
        }
    }

    private class ChooseVideoButtonListener
    implements ActionListener {
        private ChooseVideoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(TLanguage.getString("TVideoChooser.CHOOSE_VIDEO"));
            fileChooser.setCurrentDirectory(defaultDirectory);
            fileChooser.addChoosableFileFilter(new VideoFilter());
            fileChooser.setAcceptAllFileFilterUsed(false);
            int returnValue = fileChooser.showOpenDialog(null);
            if (returnValue == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                defaultDirectory = selectedFile.getParentFile();
                try {
                    selectedFile = TFileHandler.importFile(selectedFile);
                    TVideoChooser.this.setVideoFilePath(selectedFile.getAbsolutePath());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("TVideoChooser.OPEN_FILE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
                }
            }
        }
    }
}

