/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;

public class TUnorderList
extends JPanel {
    private static int LIST_MIN_HEIGHT = 91;
    private static int LIST_MIN_WIDTH = 200;
    private JScrollPane listScroll;
    private JList unorderList;

    public TUnorderList() {
        this.createUnorderList();
        this.setLayout(new BorderLayout());
        this.add((Component)this.listScroll, "Center");
    }

    private void createUnorderList() {
        this.listScroll = new JScrollPane();
        this.listScroll.setPreferredSize(new Dimension(LIST_MIN_WIDTH, LIST_MIN_HEIGHT));
        this.listScroll.setVerticalScrollBarPolicy(20);
        this.listScroll.setHorizontalScrollBarPolicy(30);
        this.unorderList = new JList();
        this.unorderList.setMinimumSize(new Dimension(LIST_MIN_WIDTH, LIST_MIN_HEIGHT));
        this.listScroll.setViewportView(this.unorderList);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.unorderList.setOpaque(enabled);
        this.unorderList.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.unorderList.isEnabled();
    }

    public boolean isSelectionEmpty() {
        return this.unorderList.isSelectionEmpty();
    }

    public Object getSelectedValue() {
        return this.unorderList.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.unorderList.getSelectedIndex();
    }

    public void setSelectedValue(Object value) {
        this.unorderList.setSelectedValue(value, true);
    }

    public void setSelectedIndex(int index) {
        this.unorderList.setSelectedIndex(index);
    }

    public void removeSelectedValue() {
        ArrayList cellList = this.getList();
        cellList.remove(this.unorderList.getSelectedValue());
        this.unorderList.setListData(cellList.toArray());
    }

    public void addElement(Object value) {
        ArrayList cellList = this.getList();
        if (!cellList.contains(value)) {
            cellList.add(value);
        }
        this.unorderList.setListData(cellList.toArray());
        this.setSelectedValue(value);
    }

    public void removeElement(Object value) {
        ArrayList cellList = this.getList();
        cellList.remove(value);
        this.unorderList.setListData(cellList.toArray());
    }

    public void removeElement(int index) {
        ArrayList cellList = this.getList();
        cellList.remove(index);
        this.unorderList.setListData(cellList.toArray());
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.unorderList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.unorderList.removeListSelectionListener(listener);
    }

    public ArrayList getList() {
        ArrayList cellList = new ArrayList();
        int i2 = 0;
        while (i2 < this.unorderList.getModel().getSize()) {
            cellList.add(this.unorderList.getModel().getElementAt(i2));
            ++i2;
        }
        return cellList;
    }

    public void setList(ArrayList list) {
        this.unorderList.setListData(list.toArray());
    }
}

