/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Vector;
import javax.swing.JPanel;
import tico.components.TToolBar;

public class TToolBarContainer
extends JPanel {
    private static final int MINIMUM_HEIGHT = 5;
    private ToolBarEventsListener toolBarListener;
    private Vector toolBarsList;

    public TToolBarContainer() {
        this.setLayout(new FlowLayout(3, 0, 0));
        ToolBarContainerEventsListener listener = new ToolBarContainerEventsListener();
        this.addComponentListener(listener);
        this.addContainerListener(listener);
        this.toolBarListener = new ToolBarEventsListener();
        this.toolBarsList = new Vector();
    }

    public void addToolBar(TToolBar toolBar) {
        toolBar.addComponentListener(this.toolBarListener);
        this.toolBarsList.add(toolBar);
        super.add(toolBar);
    }

    public void addToolBar(TToolBar toolBar, int index) {
        toolBar.addComponentListener(this.toolBarListener);
        this.toolBarsList.add(index, toolBar);
        super.add((Component)toolBar, index);
    }

    public TToolBar getToolBar(int index) {
        return (TToolBar)this.toolBarsList.elementAt(index);
    }

    public void removeToolBar(TToolBar toolBar) {
        super.remove(toolBar);
        toolBar.removeComponentListener(this.toolBarListener);
        this.toolBarsList.remove(toolBar);
    }

    public void removeToolBar(int index) {
        TToolBar removalToolBar = (TToolBar)this.toolBarsList.elementAt(index);
        super.remove(removalToolBar);
        removalToolBar.removeComponentListener(this.toolBarListener);
        this.toolBarsList.remove(index);
    }

    private void updateContainerSize() {
        int toolPanelWidth = this.getWidth();
        int acumulatedRowWidth = 0;
        int currentRowHeight = 0;
        int newToolPanelHeight = 0;
        int i2 = 0;
        while (i2 < this.getComponentCount()) {
            if (((TToolBar)this.getComponent(i2)).isVisible()) {
                int currentWidth = ((TToolBar)this.getComponent(i2)).getWidth();
                int currentHeight = ((TToolBar)this.getComponent(i2)).getHeight();
                if ((acumulatedRowWidth += currentWidth) > toolPanelWidth) {
                    acumulatedRowWidth = currentWidth;
                    newToolPanelHeight += currentRowHeight;
                    currentRowHeight = 0;
                }
                if (currentRowHeight < currentHeight) {
                    currentRowHeight = currentHeight;
                }
            }
            ++i2;
        }
        if ((newToolPanelHeight += currentRowHeight) < 5) {
            newToolPanelHeight = 5;
        }
        this.setPreferredSize(new Dimension(0, newToolPanelHeight));
        this.updateUI();
    }

    private class ToolBarContainerEventsListener
    implements ComponentListener,
    ContainerListener {
        private ToolBarContainerEventsListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e2) {
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
        }

        @Override
        public void componentShown(ComponentEvent e2) {
        }

        @Override
        public void componentResized(ComponentEvent e2) {
            TToolBarContainer.this.updateContainerSize();
        }

        @Override
        public void componentAdded(ContainerEvent e2) {
            TToolBar addedToolBar = (TToolBar)e2.getChild();
            addedToolBar.setOrientation(0);
            TToolBarContainer.this.setComponentZOrder(addedToolBar, TToolBarContainer.this.toolBarsList.indexOf(addedToolBar));
            TToolBarContainer.this.updateContainerSize();
        }

        @Override
        public void componentRemoved(ContainerEvent e2) {
            TToolBarContainer.this.updateContainerSize();
        }
    }

    private class ToolBarEventsListener
    implements ComponentListener {
        private ToolBarEventsListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e2) {
            TToolBarContainer.this.updateContainerSize();
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
        }

        @Override
        public void componentResized(ComponentEvent e2) {
            TToolBarContainer.this.updateContainerSize();
        }

        @Override
        public void componentShown(ComponentEvent e2) {
            TToolBarContainer.this.updateContainerSize();
        }
    }
}

