/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;

public class TTextAlignSelectorPanel
extends JPanel {
    private ButtonGroup horizontalButtonGroup;
    private ButtonGroup verticalButtonGroup;
    private JToggleButton horizontalLeftAlignToggleButton;
    private JToggleButton horizontalCenterAlignToggleButton;
    private JToggleButton horizontalRightAlignToggleButton;
    private JToggleButton verticalTopAlignToggleButton;
    private JToggleButton verticalCenterAlignToggleButton;
    private JToggleButton verticalBottomAlignToggleButton;

    public TTextAlignSelectorPanel() {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TTextAlignSelectorPanel.TITLE")));
        this.createButtons();
        this.setLayout(new FlowLayout());
        this.add(this.horizontalLeftAlignToggleButton);
        this.add(this.horizontalCenterAlignToggleButton);
        this.add(this.horizontalRightAlignToggleButton);
        this.add(new JPanel());
        this.add(this.verticalTopAlignToggleButton);
        this.add(this.verticalCenterAlignToggleButton);
        this.add(this.verticalBottomAlignToggleButton);
        this.horizontalCenterAlignToggleButton.setSelected(true);
        this.verticalCenterAlignToggleButton.setSelected(true);
    }

    private void createButtons() {
        this.horizontalButtonGroup = new ButtonGroup();
        this.horizontalLeftAlignToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-horizontal-align-left-32.png"));
        this.horizontalLeftAlignToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.horizontalLeftAlignToggleButton.setToolTipText(TLanguage.getString("TTextAlignSelectorPanel.LEFT_HALIGN_TOOLTIP"));
        this.horizontalCenterAlignToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-horizontal-align-center-32.png"));
        this.horizontalCenterAlignToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.horizontalCenterAlignToggleButton.setToolTipText(TLanguage.getString("TTextAlignSelectorPanel.CENTER_HALIGN_TOOLTIP"));
        this.horizontalRightAlignToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-horizontal-align-right-32.png"));
        this.horizontalRightAlignToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.horizontalRightAlignToggleButton.setToolTipText(TLanguage.getString("TTextAlignSelectorPanel.RIGHT_HALIGN_TOOLTIP"));
        this.horizontalButtonGroup.add(this.horizontalLeftAlignToggleButton);
        this.horizontalButtonGroup.add(this.horizontalCenterAlignToggleButton);
        this.horizontalButtonGroup.add(this.horizontalRightAlignToggleButton);
        this.verticalButtonGroup = new ButtonGroup();
        this.verticalTopAlignToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-vertical-align-top-32.png"));
        this.verticalTopAlignToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.verticalTopAlignToggleButton.setToolTipText(TLanguage.getString("TTextAlignSelectorPanel.TOP_VALIGN_TOOLTIP"));
        this.verticalCenterAlignToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-vertical-align-center-32.png"));
        this.verticalCenterAlignToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.verticalCenterAlignToggleButton.setToolTipText(TLanguage.getString("TTextAlignSelectorPanel.CENTER_VALIGN_TOOLTIP"));
        this.verticalBottomAlignToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-vertical-align-bottom-32.png"));
        this.verticalBottomAlignToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.verticalBottomAlignToggleButton.setToolTipText(TLanguage.getString("TTextAlignSelectorPanel.BOTTOM_VALIGN_TOOLTIP"));
        this.verticalButtonGroup.add(this.verticalTopAlignToggleButton);
        this.verticalButtonGroup.add(this.verticalCenterAlignToggleButton);
        this.verticalButtonGroup.add(this.verticalBottomAlignToggleButton);
    }

    public int getHorizontalAlignment() {
        if (this.horizontalLeftAlignToggleButton.isSelected()) {
            return 2;
        }
        if (this.horizontalRightAlignToggleButton.isSelected()) {
            return 4;
        }
        return 0;
    }

    public void setHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 2: {
                this.horizontalLeftAlignToggleButton.setSelected(true);
                break;
            }
            case 4: {
                this.horizontalRightAlignToggleButton.setSelected(true);
                break;
            }
            default: {
                this.horizontalCenterAlignToggleButton.setSelected(true);
            }
        }
    }

    public int getVerticalAlignment() {
        if (this.verticalTopAlignToggleButton.isSelected()) {
            return 1;
        }
        if (this.verticalBottomAlignToggleButton.isSelected()) {
            return 3;
        }
        return 0;
    }

    public void setVerticalAlignment(int alignment) {
        switch (alignment) {
            case 1: {
                this.verticalTopAlignToggleButton.setSelected(true);
                break;
            }
            case 3: {
                this.verticalBottomAlignToggleButton.setSelected(true);
                break;
            }
            default: {
                this.verticalCenterAlignToggleButton.setSelected(true);
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        this.horizontalLeftAlignToggleButton.addActionListener(listener);
        this.horizontalCenterAlignToggleButton.addActionListener(listener);
        this.horizontalRightAlignToggleButton.addActionListener(listener);
        this.verticalTopAlignToggleButton.addActionListener(listener);
        this.verticalCenterAlignToggleButton.addActionListener(listener);
        this.verticalBottomAlignToggleButton.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.horizontalLeftAlignToggleButton.removeActionListener(listener);
        this.horizontalCenterAlignToggleButton.removeActionListener(listener);
        this.horizontalRightAlignToggleButton.removeActionListener(listener);
        this.verticalTopAlignToggleButton.removeActionListener(listener);
        this.verticalCenterAlignToggleButton.removeActionListener(listener);
        this.verticalBottomAlignToggleButton.removeActionListener(listener);
    }
}

