/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import com.cloudgarden.speech.userinterface.SpeechEngineChooser;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import tico.configuration.TLanguage;

public class TSynthesizerConfig
extends JPanel {
    private SpeechEngineChooser chooser = null;
    private JTextField texto;
    private JTextField copiar;
    private JButton sapiBtn;
    private int mode;
    private JRadioButton googleRB;
    private JRadioButton sapiRB;

    public TSynthesizerConfig(boolean proyecto) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TSynthesizerConfig.TITLE")));
        this.setLayout(new BoxLayout(this, 1));
        this.agreagarRadioButtons();
        if (!proyecto) {
            this.agregarTextoYBoton(this);
        }
        this.botonConfigVoz();
    }

    public final void botonConfigVoz() {
        this.sapiBtn = new JButton(TLanguage.getString("TSynthesizerConfig.CONFIGURE_VOICE"));
        this.add(this.sapiBtn);
        this.sapiBtn.addActionListener(new mostrarDialogoVoz());
    }

    public void setTexto(String txt) {
        this.texto.setText(txt);
    }

    public String getTexto() {
        if (this.texto.getText().equals("")) {
            return null;
        }
        return this.texto.getText();
    }

    public String getNombreVoz() {
        try {
            String voice = this.chooser.getVoice().getName();
            return voice;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int m2) {
        switch (m2) {
            case 0: {
                this.sapiBtn.setVisible(false);
                this.googleRB.setSelected(true);
                break;
            }
            case 1: {
                this.sapiBtn.setVisible(true);
                this.sapiRB.setSelected(true);
            }
        }
        this.mode = m2;
    }

    private void agregarTextoYBoton(JPanel dest) {
        JPanel ct = new JPanel();
        this.texto = new JTextField(20);
        ct.add(this.texto);
        JButton copiarBt = new JButton(TLanguage.getString("TSynthesizerConfig.COPY_TEXT"));
        copiarBt.addActionListener(new copiar());
        ct.add(copiarBt);
        dest.add(ct);
    }

    private void agreagarRadioButtons() {
        JPanel radioPanel = new JPanel();
        this.googleRB = new JRadioButton(TLanguage.getString("TSynthesizerConfig.GOOGLE_VOICE"), true);
        this.googleRB.setActionCommand(String.valueOf(0));
        this.sapiRB = new JRadioButton(TLanguage.getString("TSynthesizerConfig.SYSTEM_VOICE"), false);
        this.sapiRB.setActionCommand(String.valueOf(1));
        this.googleRB.addActionListener(new elegirModo());
        this.sapiRB.addActionListener(new elegirModo());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.googleRB);
        bg.add(this.sapiRB);
        radioPanel.add(this.googleRB);
        radioPanel.add(this.sapiRB);
        this.add(radioPanel);
    }

    public void setCopyFrom(JTextField txt) {
        this.copiar = txt;
    }

    private class copiar
    implements ActionListener {
        private copiar() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            TSynthesizerConfig.this.texto.setText(TSynthesizerConfig.this.copiar.getText());
        }
    }

    private class elegirModo
    implements ActionListener {
        private elegirModo() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int ac2 = Integer.parseInt(e2.getActionCommand());
            TSynthesizerConfig.this.setMode(ac2);
        }
    }

    private class mostrarDialogoVoz
    implements ActionListener {
        private mostrarDialogoVoz() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            TSynthesizerConfig.this.chooser = SpeechEngineChooser.getSynthesizerDialog();
            TSynthesizerConfig.this.chooser.show();
        }
    }
}

