/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import tico.configuration.TLanguage;

public class TSizeChooser
extends JPanel {
    private static final Dimension DEFAULT_DIMENSION = new Dimension(800, 600);
    private JSpinner widthSpinner;
    private JSpinner heightSpinner;

    public TSizeChooser() {
        this(DEFAULT_DIMENSION);
    }

    public TSizeChooser(Dimension size) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TSizeChooser.TITLE")));
        SpinnerNumberModel widthSpinnerModel = new SpinnerNumberModel(1, 1, 10000, 10);
        SpinnerNumberModel heightSpinnerModel = new SpinnerNumberModel(1, 1, 10000, 10);
        JLabel widthLabel = new JLabel(TLanguage.getString("TSizeChooser.WIDTH"));
        this.widthSpinner = new JSpinner(widthSpinnerModel);
        JLabel heightLabel = new JLabel(TLanguage.getString("TSizeChooser.HEIGHT"));
        this.heightSpinner = new JSpinner(heightSpinnerModel);
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        widthLabel.setHorizontalAlignment(4);
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 10, 0);
        c2.weightx = 0.5;
        c2.weighty = 1.0;
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)widthLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 5, 10, 0);
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        c2.gridx = 1;
        c2.gridy = 0;
        this.add((Component)this.widthSpinner, c2);
        heightLabel.setHorizontalAlignment(4);
        c2.fill = 1;
        c2.insets = new Insets(10, 20, 10, 0);
        c2.weightx = 0.5;
        c2.weighty = 1.0;
        c2.gridx = 2;
        c2.gridy = 0;
        this.add((Component)heightLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 5, 10, 10);
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        c2.gridx = 3;
        c2.gridy = 0;
        this.add((Component)this.heightSpinner, c2);
        this.setSize(size);
    }

    public Dimension getSelectedSize() {
        return new Dimension((Integer)this.widthSpinner.getValue(), (Integer)this.heightSpinner.getValue());
    }

    public void setSelectedSize(Dimension size) {
        this.widthSpinner.getModel().setValue(new Integer(size.width));
        this.heightSpinner.getModel().setValue(new Integer(size.height));
    }
}

