/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.jgraph.graph.AttributeMap;
import tico.board.TBoard;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.components.TTextField;
import tico.configuration.TLanguage;

public class TSendTextChooser
extends JPanel {
    private static final String DEFAULT_TITLE = TLanguage.getString("TSendTextChooser.TITLE");
    private static final int DEFATULT_TIMER = 5;
    private JPanel textPanel;
    private TTextField sendText;
    private JPanel propertiesPanel;
    private JComboBox textReceiverComboBox;
    private JSpinner timerSpinner;

    public TSendTextChooser(TBoard board) {
        this(board, DEFAULT_TITLE);
    }

    public TSendTextChooser(TBoard board, String title) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), title));
        this.createTextPanel();
        this.createPropertiesPanel(board);
        this.updateComponents();
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 1.0;
        c2.weighty = 0.5;
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)this.textPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 1.0;
        c2.weighty = 0.5;
        c2.gridx = 0;
        c2.gridy = 1;
        this.add((Component)this.propertiesPanel, c2);
    }

    private void createTextPanel() {
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new FlowLayout(0));
        JLabel sendTextLabel = new JLabel(String.valueOf(TLanguage.getString("TSendTextChooser.SEND")) + " ");
        this.sendText = new TTextField();
        this.sendText.setColumns(25);
        this.textPanel.add(sendTextLabel);
        this.textPanel.add(this.sendText);
    }

    private void createPropertiesPanel(TBoard board) {
        this.propertiesPanel = new JPanel();
        this.propertiesPanel.setLayout(new FlowLayout(2));
        JLabel textAreaLabel = new JLabel(String.valueOf(TLanguage.getString("TSendTextChooser.TO")) + " ");
        this.createTextComponentComboBox(board);
        JLabel timerLabel = new JLabel(" " + TLanguage.getString("TSendTextChooser.DURING") + " ");
        this.timerSpinner = new JSpinner(new SpinnerNumberModel(5, 1, 1000, 1));
        JLabel secondsLabel = new JLabel(TLanguage.getString("TSendTextChooser.SECONDS"));
        this.propertiesPanel.add(textAreaLabel);
        this.propertiesPanel.add(this.textReceiverComboBox);
        this.propertiesPanel.add(timerLabel);
        this.propertiesPanel.add(this.timerSpinner);
        this.propertiesPanel.add(secondsLabel);
    }

    private void createTextComponentComboBox(TBoard board) {
        this.textReceiverComboBox = new JComboBox();
        this.textReceiverComboBox.setPreferredSize(new Dimension(120, 20));
        Vector<Object> componentList = new Vector<Object>();
        componentList.add(null);
        Object[] components = board.getGraphLayoutCache().getCells(board.getGraphLayoutCache().getCellViews());
        int i2 = 0;
        while (i2 < components.length) {
            AttributeMap map = ((TComponent)components[i2]).getAttributes();
            if (map != null && TBoardConstants.isTextReceiver(map)) {
                componentList.add(components[i2]);
            }
            ++i2;
        }
        this.textReceiverComboBox.setModel(new DefaultComboBoxModel(componentList));
        this.textReceiverComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TSendTextChooser.this.updateComponents();
            }
        });
    }

    private void updateComponents() {
        if (this.textReceiverComboBox.getModel().getSize() < 2) {
            this.sendText.setEnabled(false);
            this.textReceiverComboBox.setEnabled(false);
            this.timerSpinner.setEnabled(false);
        } else if (this.textReceiverComboBox.getSelectedItem() == null) {
            this.sendText.setEnabled(false);
            this.timerSpinner.setEnabled(false);
        } else {
            this.sendText.setEnabled(true);
            this.timerSpinner.setEnabled(true);
        }
    }

    public String getText() {
        return this.sendText.getText();
    }

    public void setText(String text) {
        this.sendText.setText(text);
    }

    public int getTimer() {
        return (Integer)this.timerSpinner.getValue();
    }

    public void setTimer(int timer) {
        if (timer == 0) {
            timer = 5;
        }
        this.timerSpinner.setValue(new Integer(timer));
    }

    public TComponent getTextReceiver() {
        if (this.textReceiverComboBox.getSelectedItem() instanceof TComponent) {
            return (TComponent)this.textReceiverComboBox.getSelectedItem();
        }
        return null;
    }

    public void setTextReceiver(TComponent textReceiver) {
        this.textReceiverComboBox.setSelectedItem(textReceiver);
    }
}

