/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tico.components.TButton;
import tico.components.events.OrderChangeEvent;
import tico.components.events.OrderChangeListener;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;

public class TOrderList
extends JPanel {
    private static int LIST_MIN_HEIGHT = 122;
    private static int LIST_MIN_WIDTH = 200;
    private JScrollPane listScroll;
    private JList orderList;
    private JPanel orderButtonPanel;
    private TButton upButton;
    private TButton downButton;

    public TOrderList() {
        this.createOrderList();
        this.createButtonPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.listScroll, "Center");
        this.add((Component)this.orderButtonPanel, "South");
        this.updateComponents();
    }

    private void createOrderList() {
        this.listScroll = new JScrollPane();
        this.listScroll.setPreferredSize(new Dimension(LIST_MIN_WIDTH, LIST_MIN_HEIGHT));
        this.listScroll.setVerticalScrollBarPolicy(20);
        this.listScroll.setHorizontalScrollBarPolicy(30);
        this.orderList = new JList();
        this.orderList.setMinimumSize(new Dimension(LIST_MIN_WIDTH, LIST_MIN_HEIGHT));
        this.orderList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                TOrderList.this.updateComponents();
            }
        });
        this.listScroll.setViewportView(this.orderList);
    }

    private void createButtonPanel() {
        this.orderButtonPanel = new JPanel();
        this.upButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TOrderList.this.selectedCellTo(TOrderList.this.orderList.getSelectedIndex() - 1);
            }
        });
        this.upButton.setIcon(TResourceManager.getImageIcon("move-up-16.png"));
        this.upButton.setMargin(new Insets(2, 2, 2, 2));
        this.upButton.setToolTipText(TLanguage.getString("TOrderList.UP_TOOLTIP"));
        this.downButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TOrderList.this.selectedCellTo(TOrderList.this.orderList.getSelectedIndex() + 1);
            }
        });
        this.downButton.setIcon(TResourceManager.getImageIcon("move-down-16.png"));
        this.downButton.setMargin(new Insets(2, 2, 2, 2));
        this.downButton.setToolTipText(TLanguage.getString("TOrderList.DOWN_TOOLTIP"));
        this.orderButtonPanel.add(this.upButton);
        this.orderButtonPanel.add(this.downButton);
    }

    private void selectedCellTo(int index) {
        ArrayList newOrderList;
        int listSize = this.orderList.getModel().getSize();
        if (index >= 0 && index < listSize) {
            newOrderList = new ArrayList();
            int i2 = 0;
            while (i2 < this.orderList.getModel().getSize()) {
                newOrderList.add(this.orderList.getModel().getElementAt(i2));
                ++i2;
            }
        } else {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + listSize);
        }
        Object selectedObject = this.orderList.getSelectedValue();
        int currentPosition = this.orderList.getSelectedIndex();
        newOrderList.remove(selectedObject);
        newOrderList.add(index, selectedObject);
        this.setList(newOrderList);
        this.orderList.setSelectedIndex(index);
        this.updateComponents();
        this.fireOrderChanged(selectedObject, currentPosition, index);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.orderList.setOpaque(enabled);
        this.orderList.setEnabled(enabled);
        this.updateComponents();
    }

    @Override
    public boolean isEnabled() {
        return this.orderList.isEnabled();
    }

    public boolean isSelectionEmpty() {
        return this.orderList.isSelectionEmpty();
    }

    public Object getSelectedValue() {
        return this.orderList.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.orderList.getSelectedIndex();
    }

    public void setSelectedValue(Object value) {
        this.orderList.setSelectedValue(value, true);
    }

    public void setSelectedIndex(int index) {
        this.orderList.setSelectedIndex(index);
    }

    public void removeSelectedValue() {
        ArrayList cellList = this.getList();
        cellList.remove(this.orderList.getSelectedValue());
        this.orderList.setListData(cellList.toArray());
    }

    public void addElement(Object value) {
        ArrayList cellList = this.getList();
        if (!cellList.contains(value)) {
            cellList.add(value);
        }
        this.orderList.setListData(cellList.toArray());
        this.setSelectedValue(value);
    }

    public void removeElement(Object value) {
        ArrayList cellList = this.getList();
        cellList.remove(value);
        this.orderList.setListData(cellList.toArray());
    }

    public void removeElement(int index) {
        ArrayList cellList = this.getList();
        cellList.remove(index);
        this.orderList.setListData(cellList.toArray());
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.orderList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.orderList.removeListSelectionListener(listener);
    }

    public void addOrderChangeListener(OrderChangeListener listener) {
        this.listenerList.add(OrderChangeListener.class, listener);
    }

    public void removeOrderChangeListener(OrderChangeListener listener) {
        this.listenerList.remove(OrderChangeListener.class, listener);
    }

    private void fireOrderChanged(Object changedObject, int initialPosition, int finalPosition) {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == OrderChangeListener.class) {
                ((OrderChangeListener)listeners[i2 + 1]).orderChanged(new OrderChangeEvent(this, changedObject, initialPosition, finalPosition));
            }
            i2 -= 2;
        }
    }

    private void updateComponents() {
        if (this.orderList.isEnabled()) {
            this.upButton.setEnabled(!this.orderList.isSelectionEmpty());
            this.downButton.setEnabled(!this.orderList.isSelectionEmpty());
            if (!this.orderList.isSelectionEmpty()) {
                this.upButton.setEnabled(this.orderList.getSelectedIndex() != 0);
                this.downButton.setEnabled(this.orderList.getSelectedIndex() != this.orderList.getModel().getSize() - 1);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public ArrayList getList() {
        ArrayList cellList = new ArrayList();
        int i2 = 0;
        while (i2 < this.orderList.getModel().getSize()) {
            cellList.add(this.orderList.getModel().getElementAt(i2));
            ++i2;
        }
        return cellList;
    }

    public void setList(ArrayList list) {
        this.orderList.setListData(list.toArray());
    }
}

