/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import tico.components.TBorderSizeComboBox;
import tico.components.TColorComboBox;
import tico.configuration.TLanguage;

public class TLineSelectionPanel
extends JPanel {
    private static final int DEFAULT_BORDER_SIZE = 1;
    private static final Color DEFAULT_BORDER_COLOR = null;
    private TColorComboBox colorComboBox;
    private TBorderSizeComboBox sizeComboBox;

    public TLineSelectionPanel() {
        this(DEFAULT_BORDER_COLOR, 1);
    }

    public TLineSelectionPanel(Color color) {
        this(color, 1);
    }

    public TLineSelectionPanel(int borderSize) {
        this(DEFAULT_BORDER_COLOR, borderSize);
    }

    public TLineSelectionPanel(Color color, int borderSize) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TLineSelectionPanel.TITLE")));
        JLabel colorLabel = new JLabel(TLanguage.getString("TLineSelectionPanel.COLOR"));
        this.colorComboBox = new TColorComboBox(false);
        JLabel borderSizeLabel = new JLabel(TLanguage.getString("TLineSelectionPanel.SIZE"));
        this.sizeComboBox = new TBorderSizeComboBox();
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        colorLabel.setHorizontalAlignment(4);
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 10, 0);
        c2.weightx = 0.5;
        c2.weighty = 1.0;
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)colorLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 5, 10, 0);
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        c2.gridx = 1;
        c2.gridy = 0;
        this.add((Component)this.colorComboBox, c2);
        borderSizeLabel.setHorizontalAlignment(4);
        c2.fill = 1;
        c2.insets = new Insets(10, 20, 10, 0);
        c2.weightx = 0.5;
        c2.weighty = 1.0;
        c2.gridx = 2;
        c2.gridy = 0;
        this.add((Component)borderSizeLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 5, 10, 10);
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        c2.gridx = 3;
        c2.gridy = 0;
        this.add((Component)this.sizeComboBox, c2);
        this.colorComboBox.addActionListener(new ChangeColorListener());
        this.setLineColor(color);
        this.setLineSize(borderSize);
    }

    public Color getLineColor() {
        return this.colorComboBox.getColor();
    }

    public void setLineColor(Color lineColor) {
        if (lineColor == null) {
            lineColor = UIManager.getColor("Tree.textForeground");
        }
        this.colorComboBox.setColor(lineColor);
    }

    public int getLineSize() {
        return this.sizeComboBox.getBorderSize();
    }

    public void setLineSize(int lineSize) {
        this.sizeComboBox.setBorderSize(lineSize);
    }

    public void addActionListener(ActionListener listener) {
        this.colorComboBox.addActionListener(listener);
        this.sizeComboBox.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.colorComboBox.removeActionListener(listener);
        this.sizeComboBox.removeActionListener(listener);
    }

    private class ChangeColorListener
    implements ActionListener {
        private ChangeColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (TLineSelectionPanel.this.getLineColor() == null) {
                TLineSelectionPanel.this.sizeComboBox.setEnabled(false);
            } else {
                TLineSelectionPanel.this.sizeComboBox.setEnabled(true);
            }
        }
    }
}

