/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Dimension;
import java.io.File;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import tico.components.TComboBox;
import tico.configuration.TLanguage;

public class TLanguageComboBox
extends TComboBox {
    protected static final int DEFAULT_WIDTH = 120;
    private Map languagesMap = TLanguage.getLanguages();

    public TLanguageComboBox() {
        this((String)null);
    }

    public TLanguageComboBox(String language) {
        this.setModel(this.createLanguagesModel());
        if (language != null) {
            this.setLanguage(language);
        }
    }

    protected DefaultComboBoxModel createLanguagesModel() {
        DefaultComboBoxModel<String> languagesModel = new DefaultComboBoxModel<String>();
        for (Map.Entry languageEntry : this.languagesMap.entrySet()) {
            String currentLanguage = (String)languageEntry.getKey();
            languagesModel.addElement(currentLanguage);
        }
        return languagesModel;
    }

    public String getLanguage() {
        return (String)this.getSelectedItem();
    }

    public void setLanguage(String language) {
        this.setSelectedItem(language);
    }

    public File getLanguageFile() {
        return (File)this.languagesMap.get((String)this.getSelectedItem());
    }

    @Override
    protected void setDefaultSize() {
        this.setMinimumSize(new Dimension(120, 25));
        this.setPreferredSize(new Dimension(120, 25));
    }
}

