/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import tico.board.TBoard;
import tico.configuration.TLanguage;

public class TInitialBoardSelectionPanel
extends JPanel {
    private static final String DEFAULT_TITLE = TLanguage.getString("TInitialBoardSelectionPanel.TITLE");
    private JPanel selectBoardPanel;
    private JComboBox initialBoardComboBox;

    public TInitialBoardSelectionPanel(ArrayList boardList) {
        this(DEFAULT_TITLE, boardList);
    }

    public TInitialBoardSelectionPanel(String title, ArrayList boardList) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), title));
        this.createSelectBoardPanel(boardList);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)this.selectBoardPanel, c2);
    }

    private void createSelectBoardPanel(ArrayList boardList) {
        this.selectBoardPanel = new JPanel();
        JLabel boardLabel = new JLabel(TLanguage.getString("TInitialBoardSelectionPanel.INITIAL_BOARD"));
        this.initialBoardComboBox = new JComboBox();
        this.initialBoardComboBox.setPreferredSize(new Dimension(150, 20));
        this.initialBoardComboBox.setModel(new DefaultComboBoxModel<Object>(boardList.toArray()));
        GridBagConstraints c2 = new GridBagConstraints();
        this.selectBoardPanel.setLayout(new GridBagLayout());
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 0);
        c2.gridx = 0;
        c2.gridy = 0;
        this.selectBoardPanel.add((Component)boardLabel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 1;
        c2.gridy = 0;
        this.selectBoardPanel.add((Component)this.initialBoardComboBox, c2);
    }

    public TBoard getInitialBoard() {
        return (TBoard)this.initialBoardComboBox.getSelectedItem();
    }

    public void setInitialBoard(TBoard board) {
        this.initialBoardComboBox.setSelectedItem(board);
    }
}

