/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import tico.components.resources.TFileUtils;

public class TImagePreview
extends JLabel
implements PropertyChangeListener {
    private static final int PREVIEW_WIDTH = 100;
    private static final int PREVIEW_HEIGHT = 100;
    private static final int PREVIEW_MARGIN = 15;

    public TImagePreview(JFileChooser fileChooser) {
        this.setPreferredSize(new Dimension(100, 100));
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        fileChooser.addPropertyChangeListener(this);
    }

    private void setImageFile(File imageFile) {
        ImageIcon image = null;
        if (imageFile != null) {
            if (TFileUtils.isJAIRequired(imageFile)) {
                RenderedOp src = JAI.create("fileload", imageFile.getAbsolutePath());
                BufferedImage bufferedImage = src.getAsBufferedImage();
                image = new ImageIcon(bufferedImage);
            } else {
                image = new ImageIcon(imageFile.getAbsolutePath());
            }
            int maxPreviewHeight = 85;
            if (image.getIconHeight() > maxPreviewHeight) {
                image = new ImageIcon(image.getImage().getScaledInstance(-1, maxPreviewHeight, 4));
            }
            int maxPreviewWidth = 85;
            if (image.getIconWidth() > maxPreviewWidth) {
                image = new ImageIcon(image.getImage().getScaledInstance(maxPreviewWidth, -1, 4));
            }
        }
        this.setIcon(image);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        String prop = e2.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.setImageFile(null);
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.setImageFile((File)e2.getNewValue());
        }
    }
}

