/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import dialogs.AddImageFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TImagePreview;
import tico.components.resources.ImageFilter;
import tico.components.resources.TFileUtils;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.editor.TFileHandler;
import tico.imageGallery.TImageGalleryButton;

public class TImageChooser
extends JPanel {
    private static final int ICON_LABEL_WIDTH = 100;
    private static final int ICON_LABEL_HEIGHT = 80;
    private static final int ICON_LABEL_MARGIN = 3;
    public static final int NO_OPTIONS_TYPE = 0;
    public static final int TEXT_POSITION_TYPE = 1;
    public static final int RESIZE_STYLE_TYPE = 2;
    private static final int DEFAULT_TYPE = 0;
    private static final String DEFAULT_TITLE = TLanguage.getString("TImageChooser.TITLE");
    private ImageIcon icon;
    private JFileChooser fileChooser;
    private JLabel iconLabel;
    private JPanel propertiesPanel;
    private JToggleButton topTextPositionToggleButton;
    private JToggleButton centerTextPositionToggleButton;
    private JToggleButton bottomTextPositionToggleButton;
    private JToggleButton fitResizeStyleToggleButton;
    private JToggleButton scaleResizeStyleToggleButton;
    private JToggleButton centerResizeStyleToggleButton;
    private JPanel buttonPanel;
    private TButton clearIconButton;
    private TImageGalleryButton galleryButton;
    private TButton openChooserDialogButton;
    protected TEditor editor;
    private static File defaultDirectory = null;
    public static String path = null;

    public TImageChooser(TEditor editor) {
        this(DEFAULT_TITLE, 0, editor);
    }

    public TImageChooser() {
        this(DEFAULT_TITLE, 0);
    }

    public TImageChooser(String title) {
        this(title, 0);
    }

    public TImageChooser(String title, TEditor editor) {
        this(title, 0, editor);
    }

    public TImageChooser(int type, TEditor editor) {
        this(DEFAULT_TITLE, type, editor);
    }

    public TImageChooser(int type) {
        this(DEFAULT_TITLE, type);
    }

    public TImageChooser(String title, int type, TEditor editor) {
        this.editor = editor;
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), title));
        this.createIconLabel();
        this.createButtonPanel();
        this.createPropertiesPanel(type);
        this.updateComponents();
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        c2.gridx = 0;
        c2.gridy = 0;
        c2.gridheight = 2;
        this.add((Component)this.iconLabel, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        c2.gridx = 1;
        c2.gridy = 0;
        c2.gridheight = 1;
        this.add((Component)this.propertiesPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        c2.gridx = 1;
        c2.gridy = 1;
        this.add((Component)this.buttonPanel, c2);
    }

    public TImageChooser(String title, int type) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), title));
        this.createIconLabel();
        this.createButtonPanel();
        this.createPropertiesPanel(type);
        this.updateComponents();
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c2.fill = 2;
        c2.insets = new Insets(10, 10, 10, 0);
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        c2.gridx = 0;
        c2.gridy = 0;
        c2.gridheight = 2;
        this.add((Component)this.iconLabel, c2);
        c2.fill = 2;
        c2.insets = new Insets(10, 5, 0, 10);
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        c2.gridx = 1;
        c2.gridy = 0;
        c2.gridheight = 1;
        this.add((Component)this.propertiesPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 5, 10, 10);
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        c2.gridx = 1;
        c2.gridy = 1;
        this.add((Component)this.buttonPanel, c2);
    }

    private void createIconLabel() {
        this.iconLabel = new JLabel();
        this.iconLabel.setMinimumSize(new Dimension(100, 80));
        this.iconLabel.setPreferredSize(new Dimension(100, 80));
        this.iconLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.iconLabel.setVerticalAlignment(0);
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setBackground(Color.WHITE);
    }

    private void createPropertiesPanel(int type) {
        this.propertiesPanel = new JPanel();
        ButtonGroup propertiesButtonGroup = new ButtonGroup();
        this.topTextPositionToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-vertical-textposition-top-32.png"));
        this.topTextPositionToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.topTextPositionToggleButton.setToolTipText(TLanguage.getString("TImageChooser.TOP_TEXT_TOOLTIP"));
        this.centerTextPositionToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-vertical-textposition-center-32.png"));
        this.centerTextPositionToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.centerTextPositionToggleButton.setToolTipText(TLanguage.getString("TImageChooser.CENTER_TEXT_TOOLTIP"));
        this.bottomTextPositionToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-vertical-textposition-bottom-32.png"));
        this.bottomTextPositionToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.bottomTextPositionToggleButton.setToolTipText(TLanguage.getString("TImageChooser.BOTTOM_TEXT_TOOLTIP"));
        this.topTextPositionToggleButton.setEnabled(false);
        this.centerTextPositionToggleButton.setEnabled(false);
        this.bottomTextPositionToggleButton.setEnabled(false);
        this.centerResizeStyleToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-resize-style-center-32.png"));
        this.centerResizeStyleToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.centerResizeStyleToggleButton.setToolTipText(TLanguage.getString("TImageChooser.CENTER_RESIZE_TOOLTIP"));
        this.scaleResizeStyleToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-resize-style-scale-32.png"));
        this.scaleResizeStyleToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.scaleResizeStyleToggleButton.setToolTipText(TLanguage.getString("TImageChooser.SCALE_RESIZE_TOOLTIP"));
        this.fitResizeStyleToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-resize-style-fit-32.png"));
        this.fitResizeStyleToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.fitResizeStyleToggleButton.setToolTipText(TLanguage.getString("TImageChooser.FIT_RESIZE_TOOLTIP"));
        this.fitResizeStyleToggleButton.setEnabled(false);
        this.scaleResizeStyleToggleButton.setEnabled(false);
        this.centerResizeStyleToggleButton.setEnabled(false);
        switch (type) {
            case 1: {
                propertiesButtonGroup.add(this.topTextPositionToggleButton);
                propertiesButtonGroup.add(this.centerTextPositionToggleButton);
                propertiesButtonGroup.add(this.bottomTextPositionToggleButton);
                this.propertiesPanel.add(this.topTextPositionToggleButton);
                this.propertiesPanel.add(this.centerTextPositionToggleButton);
                this.propertiesPanel.add(this.bottomTextPositionToggleButton);
                break;
            }
            case 2: {
                propertiesButtonGroup.add(this.centerResizeStyleToggleButton);
                propertiesButtonGroup.add(this.scaleResizeStyleToggleButton);
                propertiesButtonGroup.add(this.fitResizeStyleToggleButton);
                this.propertiesPanel.add(this.centerResizeStyleToggleButton);
                this.propertiesPanel.add(this.scaleResizeStyleToggleButton);
                this.propertiesPanel.add(this.fitResizeStyleToggleButton);
            }
        }
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.galleryButton = new TImageGalleryButton();
        this.buttonPanel.add(this.galleryButton.createImageGalleryButton(this.editor, this));
        this.openChooserDialogButton = new TButton(TLanguage.getString("TImageChooser.BUTTON_SELECT"));
        this.openChooserDialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AddImageFrame f2 = new AddImageFrame();
                f2.setDefaultCloseOperation(2);
                f2.setResizable(false);
                f2.pack();
                f2.setModal(true);
                f2.setLocationRelativeTo(TImageChooser.this.editor);
                f2.setVisible(true);
            }
        });
        this.clearIconButton = new TButton(new AbstractAction(TLanguage.getString("TImageChooser.BUTTON_CLEAR")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TImageChooser.this.setIcon(null);
                path = null;
            }
        });
        this.buttonPanel.add(this.openChooserDialogButton);
        this.buttonPanel.add(this.clearIconButton);
    }

    public void updateComponents() {
        if (this.icon != null) {
            this.clearIconButton.setEnabled(true);
            this.topTextPositionToggleButton.setEnabled(true);
            this.centerTextPositionToggleButton.setEnabled(true);
            this.bottomTextPositionToggleButton.setEnabled(true);
            this.fitResizeStyleToggleButton.setEnabled(true);
            this.scaleResizeStyleToggleButton.setEnabled(true);
            this.centerResizeStyleToggleButton.setEnabled(true);
            ImageIcon thumbnail = this.icon;
            int maxImageWidth = this.iconLabel.getPreferredSize().width - 3;
            int maxImageHeight = this.iconLabel.getPreferredSize().height - 3;
            if (thumbnail.getIconWidth() > maxImageWidth) {
                thumbnail = new ImageIcon(thumbnail.getImage().getScaledInstance(maxImageWidth, -1, 4));
            }
            if (thumbnail.getIconHeight() > maxImageHeight) {
                thumbnail = new ImageIcon(thumbnail.getImage().getScaledInstance(-1, maxImageHeight, 4));
            }
            this.iconLabel.setText("");
            this.iconLabel.setIcon(thumbnail);
        } else {
            this.clearIconButton.setEnabled(false);
            this.topTextPositionToggleButton.setEnabled(false);
            this.centerTextPositionToggleButton.setEnabled(false);
            this.bottomTextPositionToggleButton.setEnabled(false);
            this.fitResizeStyleToggleButton.setEnabled(false);
            this.scaleResizeStyleToggleButton.setEnabled(false);
            this.centerResizeStyleToggleButton.setEnabled(false);
            this.iconLabel.setText(TLanguage.getString("TImageChooser.PREVIEW_EMPTY"));
            this.iconLabel.setIcon(null);
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
        this.updateComponents();
    }

    public int getVerticalTextPosition() {
        if (this.bottomTextPositionToggleButton.isSelected()) {
            return 3;
        }
        if (this.centerTextPositionToggleButton.isSelected()) {
            return 0;
        }
        return 1;
    }

    public void setVerticalTextPosition(int verticalTextPosition) {
        if (verticalTextPosition == 3) {
            this.bottomTextPositionToggleButton.setSelected(true);
        } else if (verticalTextPosition == 0) {
            this.centerTextPositionToggleButton.setSelected(true);
        } else {
            this.topTextPositionToggleButton.setSelected(true);
        }
    }

    public int getResizeStyle() {
        if (this.centerResizeStyleToggleButton.isSelected()) {
            return 2;
        }
        if (this.fitResizeStyleToggleButton.isSelected()) {
            return 0;
        }
        return 1;
    }

    public void setResizeStyle(int resizeStyle) {
        if (resizeStyle == 2) {
            this.centerResizeStyleToggleButton.setSelected(true);
        } else if (resizeStyle == 0) {
            this.fitResizeStyleToggleButton.setSelected(true);
        } else {
            this.scaleResizeStyleToggleButton.setSelected(true);
        }
    }

    public TImageGalleryButton getImageGalleryButton() {
        return this.galleryButton;
    }

    private class ChooseIconButtonListener
    implements ActionListener {
        private ChooseIconButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            TImageChooser.this.fileChooser = new JFileChooser();
            TImageChooser.this.fileChooser.setDialogTitle(TLanguage.getString("TImageChooser.CHOOSE_IMAGE"));
            TImageChooser.this.fileChooser.setCurrentDirectory(defaultDirectory);
            TImageChooser.this.fileChooser.addChoosableFileFilter(new ImageFilter());
            TImageChooser.this.fileChooser.setAcceptAllFileFilterUsed(false);
            TImageChooser.this.fileChooser.setAccessory(new TImagePreview(TImageChooser.this.fileChooser));
            int returnValue = TImageChooser.this.fileChooser.showOpenDialog(null);
            if (returnValue == 0) {
                File selectedFile = TImageChooser.this.fileChooser.getSelectedFile();
                defaultDirectory = selectedFile.getParentFile();
                try {
                    ImageIcon newImageIcon;
                    selectedFile = TFileHandler.importFile(selectedFile);
                    if (TFileUtils.isJAIRequired(selectedFile)) {
                        RenderedOp src = JAI.create("fileload", selectedFile.getAbsolutePath());
                        BufferedImage bufferedImage = src.getAsBufferedImage();
                        newImageIcon = new ImageIcon(bufferedImage, selectedFile.getAbsolutePath());
                        path = selectedFile.getAbsolutePath();
                    } else {
                        newImageIcon = new ImageIcon(selectedFile.getAbsolutePath(), selectedFile.getAbsolutePath());
                        path = selectedFile.getAbsolutePath();
                    }
                    TImageChooser.this.setIcon(newImageIcon);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("TImageChooser.CHOOSE_IMAGE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
                }
            }
        }
    }
}

