/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tico.components.TOrderList;
import tico.configuration.TLanguage;

public class TGridOrderPanel
extends JPanel {
    private static final int DEFAULT_ORDER = 0;
    private JPanel radioButtonOrderPanel;
    private JRadioButton sequentialOrderRadioButton;
    private JRadioButton columnsOrderRadioButton;
    private JRadioButton rowsOrderRadioButton;
    private JRadioButton customOrderRadioButton;
    private TOrderList orderedCellList;

    public TGridOrderPanel() {
        this(0);
    }

    public TGridOrderPanel(int order) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TGridOrderPanel.TITLE")));
        this.createRadioButtonOrderPanel();
        this.orderedCellList = new TOrderList();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)this.radioButtonOrderPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(10, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.add((Component)this.orderedCellList, c2);
        this.setOrder(order);
    }

    private void createRadioButtonOrderPanel() {
        this.radioButtonOrderPanel = new JPanel();
        this.radioButtonOrderPanel.setLayout(new GridLayout(4, 1, 0, 5));
        this.sequentialOrderRadioButton = new JRadioButton(TLanguage.getString("TGridOrderPanel.ORDER_SEQUENTIAL"));
        this.columnsOrderRadioButton = new JRadioButton(TLanguage.getString("TGridOrderPanel.ORDER_COLUMNS"));
        this.rowsOrderRadioButton = new JRadioButton(TLanguage.getString("TGridOrderPanel.ORDER_ROWS"));
        this.customOrderRadioButton = new JRadioButton(TLanguage.getString("TGridOrderPanel.ORDER_CUSTOM"));
        this.customOrderRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                TGridOrderPanel.this.updateComponents();
            }
        });
        ButtonGroup orderButtonGroup = new ButtonGroup();
        orderButtonGroup.add(this.sequentialOrderRadioButton);
        orderButtonGroup.add(this.columnsOrderRadioButton);
        orderButtonGroup.add(this.rowsOrderRadioButton);
        orderButtonGroup.add(this.customOrderRadioButton);
        this.radioButtonOrderPanel.add(this.sequentialOrderRadioButton);
        this.radioButtonOrderPanel.add(this.columnsOrderRadioButton);
        this.radioButtonOrderPanel.add(this.rowsOrderRadioButton);
        this.radioButtonOrderPanel.add(this.customOrderRadioButton);
    }

    private void updateComponents() {
        this.orderedCellList.setEnabled(this.customOrderRadioButton.isSelected());
    }

    public int getOrder() {
        if (this.columnsOrderRadioButton.isSelected()) {
            return 2;
        }
        if (this.rowsOrderRadioButton.isSelected()) {
            return 1;
        }
        if (this.customOrderRadioButton.isSelected()) {
            return 3;
        }
        return 0;
    }

    public void setOrder(int order) {
        if (order == 2) {
            this.columnsOrderRadioButton.setSelected(true);
        } else if (order == 1) {
            this.rowsOrderRadioButton.setSelected(true);
        } else if (order == 3) {
            this.customOrderRadioButton.setSelected(true);
        } else {
            this.sequentialOrderRadioButton.setSelected(true);
        }
        this.updateComponents();
    }

    public ArrayList getOrderedCellList() {
        return this.orderedCellList.getList();
    }

    public void setOrderedCellList(ArrayList cellList) {
        this.orderedCellList.setList(cellList);
    }
}

