/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tico.components.TColorComboBox;
import tico.components.TFontFaceList;
import tico.components.TFontSizeComboBox;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;

public class TFontModelChooser
extends JPanel {
    private static final String DEFAULT_FACE = "Default";
    private static final int DEFAULT_STYLE = 0;
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final int DEFAULT_SIZE = 12;
    private static final Color FONT_SAMPLE_FONT_COLOR = Color.BLACK;
    private static String SAMPLE_TEXT = TLanguage.getString("TFontModelChooser.SAMPLE_TEXT");
    private static int SAMPLE_MIN_HEIGHT = 50;
    private static int SAMPLE_MIN_WIDTH = 100;
    private static int PROPERTIES_HEIGHT = 100;
    private static int PROPERTIES_WIDTH = 120;
    private static int MIN_HEIGHT = 200;
    private static int MIN_WIDTH = 200;
    private TColorComboBox faceColorComboBox;
    private TFontSizeComboBox fontSizeComboBox;
    private TFontFaceList fontFaceList;
    private JTextPane fontSamplePane;
    private JPanel fontPropertiesPanel;
    private JToggleButton fontBoldToggleButton;
    private JToggleButton fontItalicToggleButton;

    public TFontModelChooser() {
        this(DEFAULT_FACE, DEFAULT_COLOR, 12, 0);
    }

    public TFontModelChooser(String face, Color color, int size, int style) {
        this.setMinimumSize(new Dimension(MIN_WIDTH, MIN_HEIGHT));
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TFontModelChooser.TITLE")));
        this.createFontFaceList();
        this.createFontSample();
        this.createFontPropertiesPanel();
        this.placeComponents();
        this.addListeners();
        this.setFontFace(face);
        this.setFontSize(size);
        this.setFontColor(color);
        this.setFontStyle(style);
    }

    public Font getSelectedFont() {
        return new Font(this.getFontFace(), this.getFontStyle(), this.getFontSize());
    }

    public String getFontFace() {
        return this.fontFaceList.getFontFace();
    }

    public void setFontFace(String face) {
        this.fontFaceList.setFontFace(face);
        this.updateFontSample();
    }

    public int getFontSize() {
        return this.fontSizeComboBox.getFontSize();
    }

    public void setFontSize(int size) {
        this.fontSizeComboBox.setFontSize(size);
        this.updateFontSample();
    }

    public int getFontStyle() {
        int style = 0;
        if (this.fontBoldToggleButton.isSelected()) {
            style |= 1;
        }
        if (this.fontItalicToggleButton.isSelected()) {
            style |= 2;
        }
        return style;
    }

    public void setFontStyle(int style) {
        if ((style & 1) != 0) {
            this.fontBoldToggleButton.setSelected(true);
        } else {
            this.fontBoldToggleButton.setSelected(false);
        }
        if ((style & 2) != 0) {
            this.fontItalicToggleButton.setSelected(true);
        } else {
            this.fontItalicToggleButton.setSelected(false);
        }
        this.updateFontSample();
    }

    public Color getFontColor() {
        return this.faceColorComboBox.getColor();
    }

    public void setFontColor(Color color) {
        if (color == null) {
            color = DEFAULT_COLOR;
        }
        this.faceColorComboBox.setColor(color);
        this.updateFontSample();
    }

    private void createFontFaceList() {
        this.fontFaceList = new TFontFaceList();
    }

    private void createFontPropertiesPanel() {
        this.fontPropertiesPanel = new JPanel();
        this.fontPropertiesPanel.setMinimumSize(new Dimension(PROPERTIES_WIDTH, PROPERTIES_HEIGHT));
        JLabel colorLabel = new JLabel(TLanguage.getString("TFontModelChooser.COLOR"));
        this.faceColorComboBox = new TColorComboBox();
        JLabel sizeLabel = new JLabel(TLanguage.getString("TFontModelChooser.SIZE"));
        this.fontSizeComboBox = new TFontSizeComboBox();
        JPanel fontTypesPanel = new JPanel();
        this.fontBoldToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-text-bold-32.png"));
        this.fontBoldToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.fontBoldToggleButton.setToolTipText(TLanguage.getString("TFontModelChooser.BOLD"));
        this.fontItalicToggleButton = new JToggleButton(TResourceManager.getImageIcon("format-text-italic-32.png"));
        this.fontItalicToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.fontItalicToggleButton.setToolTipText(TLanguage.getString("TFontModelChooser.ITALIC"));
        fontTypesPanel.add(this.fontBoldToggleButton);
        fontTypesPanel.add(this.fontItalicToggleButton);
        GridBagConstraints c2 = new GridBagConstraints();
        this.fontPropertiesPanel.setLayout(new GridBagLayout());
        colorLabel.setHorizontalAlignment(4);
        c2.fill = 2;
        c2.insets = new Insets(5, 5, 5, 0);
        c2.gridx = 0;
        c2.gridy = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.3;
        this.fontPropertiesPanel.add((Component)colorLabel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 5, 5, 0);
        c2.gridx = 1;
        c2.gridy = 0;
        c2.weightx = 1.0;
        c2.weighty = 0.3;
        this.fontPropertiesPanel.add((Component)this.faceColorComboBox, c2);
        sizeLabel.setHorizontalAlignment(4);
        c2.fill = 2;
        c2.insets = new Insets(5, 5, 5, 0);
        c2.gridx = 0;
        c2.gridy = 1;
        c2.weightx = 0.0;
        c2.weighty = 0.3;
        this.fontPropertiesPanel.add((Component)sizeLabel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 5, 5, 0);
        c2.gridx = 1;
        c2.gridy = 1;
        c2.weightx = 1.0;
        c2.weighty = 0.3;
        this.fontPropertiesPanel.add((Component)this.fontSizeComboBox, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 5, 5, 0);
        c2.gridx = 0;
        c2.gridy = 2;
        c2.gridwidth = 2;
        c2.weightx = 1.0;
        c2.weighty = 0.4;
        this.fontPropertiesPanel.add((Component)fontTypesPanel, c2);
    }

    private void createFontSample() {
        this.fontSamplePane = new JTextPane();
        this.fontSamplePane.setMinimumSize(new Dimension(SAMPLE_MIN_WIDTH, SAMPLE_MIN_HEIGHT));
        this.fontSamplePane.setPreferredSize(new Dimension(SAMPLE_MIN_WIDTH, SAMPLE_MIN_HEIGHT));
        this.fontSamplePane.setBorder(BorderFactory.createEtchedBorder());
        this.fontSamplePane.setEditable(false);
        this.fontSamplePane.setFocusable(false);
        this.fontSamplePane.setForeground(FONT_SAMPLE_FONT_COLOR);
        this.fontSamplePane.setText(SAMPLE_TEXT);
    }

    private void updateFontSample() {
        this.fontSamplePane.setFont(new Font(this.getFontFace(), this.getFontStyle(), this.getFontSize()));
    }

    private void placeComponents() {
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 0, 0);
        c2.gridx = 0;
        c2.gridy = 0;
        c2.weightx = 1.0;
        c2.weighty = 0.5;
        this.add((Component)this.fontFaceList, c2);
        c2.fill = 2;
        c2.insets = new Insets(10, 10, 0, 10);
        c2.gridx = 1;
        c2.gridy = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.5;
        this.add((Component)this.fontPropertiesPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 10, 10);
        c2.gridwidth = 2;
        c2.gridx = 0;
        c2.gridy = 1;
        c2.weightx = 1.0;
        c2.weighty = 0.5;
        this.add((Component)this.fontSamplePane, c2);
    }

    private void addListeners() {
        UpdateFontSampleListener listener = new UpdateFontSampleListener();
        this.fontFaceList.addListSelectionListener(listener);
        this.faceColorComboBox.addActionListener(listener);
        this.fontSizeComboBox.addActionListener(listener);
        this.fontBoldToggleButton.addActionListener(listener);
        this.fontItalicToggleButton.addActionListener(listener);
    }

    private class UpdateFontSampleListener
    implements ActionListener,
    ListSelectionListener {
        private UpdateFontSampleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            TFontModelChooser.this.updateFontSample();
        }

        @Override
        public void valueChanged(ListSelectionEvent e2) {
            TFontModelChooser.this.updateFontSample();
        }
    }
}

