/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tico.editor.TEditor;

public class TFontFaceList
extends JPanel {
    private static int LIST_MIN_HEIGHT = 120;
    private static int LIST_MIN_WIDTH = 100;
    private static String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static String DEFAULT_FONT = fonts[0];
    private JScrollPane fontListScroll;
    private JList fontList;
    private JTextField fontField;

    public TFontFaceList() {
        this(DEFAULT_FONT);
    }

    public TFontFaceList(String fontFace) {
        this.createFontList();
        this.createFontField();
        this.placeComponents();
        this.fontList.addListSelectionListener(new TFontFaceSelectionListener());
        this.setFontFace(fontFace);
    }

    private void createFontList() {
        this.fontListScroll = new JScrollPane();
        this.fontListScroll.setMinimumSize(new Dimension(LIST_MIN_WIDTH, LIST_MIN_HEIGHT));
        this.fontListScroll.setVerticalScrollBarPolicy(22);
        this.fontListScroll.setHorizontalScrollBarPolicy(31);
        this.fontList = new JList();
        this.fontList.setSelectionMode(1);
        this.fontList.setLayoutOrientation(0);
        this.fontList.setListData(fonts);
        this.fontListScroll.setViewportView(this.fontList);
        if (TEditor.get_android_mode()) {
            this.fontList.setEnabled(false);
        }
    }

    private void createFontField() {
        this.fontField = new JTextField();
        this.fontField.setEditable(false);
        this.fontField.setFocusable(false);
    }

    private void placeComponents() {
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c2.fill = 2;
        c2.gridx = 0;
        c2.gridy = 0;
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        this.add((Component)this.fontField, c2);
        c2.insets = new Insets(5, 0, 0, 0);
        c2.gridx = 0;
        c2.gridy = 1;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        this.add((Component)this.fontListScroll, c2);
    }

    public String getFontFace() {
        return (String)this.fontList.getSelectedValue();
    }

    public void setFontFace(String fontFace) {
        if (fontFace == null) {
            return;
        }
        this.fontList.setSelectedValue(fontFace, true);
        this.fontField.setText(fontFace);
        this.fontField.setCaretPosition(0);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.fontList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.fontList.removeListSelectionListener(listener);
    }

    private class TFontFaceSelectionListener
    implements ListSelectionListener {
        private TFontFaceSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                TFontFaceList.this.fontField.setText((String)TFontFaceList.this.fontList.getSelectedValue());
                TFontFaceList.this.fontField.setCaretPosition(0);
            }
        }
    }
}

