/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import tico.components.TComboBox;
import tico.configuration.TLanguage;

public class TColorComboBox
extends TComboBox {
    private static Color DEFAULT_COLOR = Color.BLACK;
    private static final boolean DEFAULT_TRANSPARENT = false;
    private static final int MAX_CUSTOM_COLORS = 4;
    private boolean allowTransparent;
    private static Object[] basicColors = new Object[]{Color.WHITE, new Color(252, 233, 79), new Color(252, 175, 62), new Color(115, 210, 22), new Color(52, 101, 164), new Color(173, 127, 168), new Color(239, 41, 41), Color.BLACK};
    private static Vector customColors = new Vector();
    private Color currentColor;

    public TColorComboBox() {
        this(DEFAULT_COLOR, false);
    }

    public TColorComboBox(Color color) {
        this(color, false);
    }

    public TColorComboBox(boolean allowTransparent) {
        this(DEFAULT_COLOR, allowTransparent);
    }

    public TColorComboBox(Color color, boolean allowTransparent) {
        this.allowTransparent = allowTransparent;
        this.setModel(this.createColorModel());
        this.setRenderer(new TColorComboListRenderer());
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                Color currentColor = TColorComboBox.this.getColor();
                TColorComboBox.this.setModel(TColorComboBox.this.createColorModel());
                TColorComboBox.this.setColor(currentColor);
            }
        });
        this.setColor(color);
    }

    private void addCustomColor(Color color) {
        if (color == null) {
            return;
        }
        int i2 = 0;
        while (basicColors.length > i2) {
            if (basicColors[i2].equals(color)) {
                return;
            }
            ++i2;
        }
        if (customColors.contains(color)) {
            return;
        }
        if (customColors.size() >= 4) {
            customColors.removeElementAt(0);
        }
        customColors.add(color);
        this.setModel(this.createColorModel());
    }

    protected DefaultComboBoxModel createColorModel() {
        DefaultComboBoxModel<Object> comboBoxModel = new DefaultComboBoxModel<Object>();
        if (this.allowTransparent) {
            comboBoxModel.addElement(null);
        }
        int i2 = 0;
        while (i2 < basicColors.length) {
            comboBoxModel.addElement((Color)basicColors[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < customColors.size()) {
            comboBoxModel.addElement((Color)customColors.get(i2));
            ++i2;
        }
        comboBoxModel.addElement("Custom");
        return comboBoxModel;
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setColor(Color color) {
        if (!this.allowTransparent && color == null) {
            throw new NullPointerException();
        }
        this.addCustomColor(color);
        this.setSelectedItem(color);
        this.currentColor = color;
    }

    @Override
    protected void fireActionEvent() {
        if (!(this.getSelectedItem() instanceof Color) && this.getSelectedItem() != null) {
            Color newColor = JColorChooser.showDialog(null, TLanguage.getString("TColorComboBox.CHOOSE_BACKGROUND_COLOR"), null);
            if (newColor == null) {
                newColor = this.currentColor;
            }
            this.setColor(newColor);
        } else {
            this.currentColor = (Color)this.getSelectedItem();
        }
        super.fireActionEvent();
    }

    private class TColorComboListRenderer
    extends JLabel
    implements ListCellRenderer {
        private Color color;
        private boolean blank;

        public TColorComboListRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(0);
            this.setBorder(new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.WHITE), new LineBorder(Color.BLACK)));
        }

        @Override
        public void paint(Graphics g2) {
            if (!this.blank) {
                this.setBackground(this.color);
                this.setForeground(this.color);
            } else {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
            }
            super.paint(g2);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Color) {
                this.color = (Color)value;
                this.setText(TLanguage.getString("TColorComboBox.COLOR"));
                this.blank = false;
            } else if (value == null) {
                this.setText(TLanguage.getString("TColorComboBox.TRANSPARENT"));
                this.blank = true;
            } else {
                this.setText(TLanguage.getString("TColorComboBox.OTHER"));
                this.blank = true;
            }
            return this;
        }
    }
}

