/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import tico.components.TTextField;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;

public class TClickControllerCellActionsPanel
extends JPanel {
    private static final String DEFAULT_TITLE = TLanguage.getString("TClickControllerCellActionsPanel.TITLE");
    private JPanel selectActionPanel;
    private ButtonGroup actions;
    private TTextField controllerCellText;

    public TTextField getTextField() {
        return this.controllerCellText;
    }

    public void setTextField(TTextField text) {
        this.controllerCellText = text;
    }

    public TClickControllerCellActionsPanel(ArrayList boardList, TTextField text) {
        this(DEFAULT_TITLE, boardList, text);
    }

    public TClickControllerCellActionsPanel(String title, ArrayList boardList, TTextField text) {
        this.setTextField(text);
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), title));
        this.createSelectActionPanel(boardList);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 10;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)this.selectActionPanel, c2);
    }

    private void createSelectActionPanel(ArrayList boardList) {
        this.selectActionPanel = new JPanel();
        GridLayout layoutActionPanel = new GridLayout(4, 4);
        layoutActionPanel.setHgap(10);
        this.selectActionPanel.setLayout(layoutActionPanel);
        JLabel exitIcon = new JLabel();
        ImageIcon exit = new ImageIcon(TResourceManager.getImageIcon("controller-exit.png").getImage().getScaledInstance(70, 70, 4));
        exitIcon.setIcon(exit);
        exitIcon.setText("");
        JLabel undoIcon = new JLabel();
        ImageIcon undo = new ImageIcon(TResourceManager.getImageIcon("controller-undo.png").getImage().getScaledInstance(70, 70, 4));
        undoIcon.setIcon(undo);
        JLabel undoAllIcon = new JLabel();
        ImageIcon undoAll = new ImageIcon(TResourceManager.getImageIcon("controller-undo-all.png").getImage().getScaledInstance(70, 70, 4));
        undoAllIcon.setIcon(undoAll);
        JLabel readIcon = new JLabel();
        ImageIcon read = new ImageIcon(TResourceManager.getImageIcon("controller-read.png").getImage().getScaledInstance(70, 70, 4));
        readIcon.setIcon(read);
        JLabel returnIcon = new JLabel();
        ImageIcon back = new ImageIcon(TResourceManager.getImageIcon("controller-return.png").getImage().getScaledInstance(70, 70, 4));
        returnIcon.setIcon(back);
        JLabel homeIcon = new JLabel();
        ImageIcon home = new ImageIcon(TResourceManager.getImageIcon("controller-home.png").getImage().getScaledInstance(70, 70, 4));
        homeIcon.setIcon(home);
        JLabel stopIcon = new JLabel();
        ImageIcon stop = new ImageIcon(TResourceManager.getImageIcon("controller-stop.png").getImage().getScaledInstance(70, 70, 4));
        stopIcon.setIcon(stop);
        JLabel copyIcon = new JLabel();
        ImageIcon imageIcon = TResourceManager.getImageIcon("controller-copy.png");
        ImageIcon copy = new ImageIcon(imageIcon.getImage().getScaledInstance(70, 70, 4));
        copyIcon.setIcon(copy);
        this.actions = new ButtonGroup();
        JRadioButton exitButton = null;
        JRadioButton undoButton = null;
        JRadioButton undoAllButton = null;
        JRadioButton readButton = null;
        JRadioButton returnButton = null;
        JRadioButton homeButton = null;
        JRadioButton stopButton = null;
        JRadioButton copyButton = null;
        int i2 = 0;
        while (i2 < boardList.size()) {
            String action = boardList.get(i2).toString();
            if (action.equals(TLanguage.getString("TInterpreterExitAction.NAME"))) {
                exitButton = new JRadioButton(action, this.getTextField().getText().equals(TLanguage.getString("TInterpreterExitAction.NAME")));
                exitButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        TClickControllerCellActionsPanel.this.controllerCellText.setText(TLanguage.getString("TInterpreterExitAction.NAME"));
                    }
                });
            } else if (action.equals(TLanguage.getString("TInterpreterUndoAction.NAME"))) {
                undoButton = new JRadioButton(action, this.getTextField().getText().equals(TLanguage.getString("TInterpreterUndoAction.NAME")));
                undoButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        TClickControllerCellActionsPanel.this.controllerCellText.setText(TLanguage.getString("TInterpreterUndoAction.NAME"));
                    }
                });
            } else if (action.equals(TLanguage.getString("TInterpreterUndoAllAction.NAME"))) {
                undoAllButton = new JRadioButton(action, this.getTextField().getText().equals(TLanguage.getString("TInterpreterUndoAllAction.NAME")));
                undoAllButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        TClickControllerCellActionsPanel.this.controllerCellText.setText(TLanguage.getString("TInterpreterUndoAllAction.NAME"));
                    }
                });
            } else if (action.equals(TLanguage.getString("TInterpreterReadAction.NAME"))) {
                readButton = new JRadioButton(action, this.getTextField().getText().equals(TLanguage.getString("TInterpreterReadAction.NAME")));
                readButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        TClickControllerCellActionsPanel.this.controllerCellText.setText(TLanguage.getString("TInterpreterReadAction.NAME"));
                    }
                });
            } else if (action.equals(TLanguage.getString("TInterpreterReturnAction.NAME"))) {
                returnButton = new JRadioButton(action, this.getTextField().getText().equals(TLanguage.getString("TInterpreterReturnAction.NAME")));
                returnButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        TClickControllerCellActionsPanel.this.controllerCellText.setText(TLanguage.getString("TInterpreterReturnAction.NAME"));
                    }
                });
            } else if (action.equals(TLanguage.getString("TInterpreterHomeAction.NAME"))) {
                homeButton = new JRadioButton(action, this.getTextField().getText().equals(TLanguage.getString("TInterpreterHomeAction.NAME")));
                homeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        TClickControllerCellActionsPanel.this.controllerCellText.setText(TLanguage.getString("TInterpreterHomeAction.NAME"));
                    }
                });
            } else if (action.equals(TLanguage.getString("TInterpreterStopAction.NAME"))) {
                stopButton = new JRadioButton(action, this.getTextField().getText().equals(TLanguage.getString("TInterpreterStopAction.NAME")));
                stopButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        TClickControllerCellActionsPanel.this.controllerCellText.setText(TLanguage.getString("TInterpreterStopAction.NAME"));
                    }
                });
            } else if (action.equals(TLanguage.getString("TInterpreterCopyAction.NAME"))) {
                copyButton = new JRadioButton(action, this.getTextField().getText().equals(TLanguage.getString("TInterpreterCopyAction.NAME")));
                copyButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        TClickControllerCellActionsPanel.this.controllerCellText.setText(TLanguage.getString("TInterpreterCopyAction.NAME"));
                    }
                });
            }
            ++i2;
        }
        this.actions.add(exitButton);
        this.actions.add(undoButton);
        this.actions.add(undoAllButton);
        this.actions.add(readButton);
        this.actions.add(returnButton);
        this.actions.add(homeButton);
        this.actions.add(stopButton);
        this.actions.add(copyButton);
        this.selectActionPanel.add(exitIcon);
        this.selectActionPanel.add(undoIcon);
        this.selectActionPanel.add(undoAllIcon);
        this.selectActionPanel.add(readIcon);
        this.selectActionPanel.add(exitButton);
        this.selectActionPanel.add(undoButton);
        this.selectActionPanel.add(undoAllButton);
        this.selectActionPanel.add(readButton);
        this.selectActionPanel.add(returnIcon);
        this.selectActionPanel.add(stopIcon);
        this.selectActionPanel.add(homeIcon);
        this.selectActionPanel.add(copyIcon);
        this.selectActionPanel.add(returnButton);
        this.selectActionPanel.add(stopButton);
        this.selectActionPanel.add(homeButton);
        this.selectActionPanel.add(copyButton);
    }
}

