/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import tico.configuration.TLanguage;

public class TClickCellActionsPanel
extends JPanel {
    private static final String DEFAULT_TITLE = TLanguage.getString("TClickCellActionsPanel.TITLE");
    private JPanel selectBoardPanel;
    private JComboBox followingBoardComboBox;
    private JPanel accumulatePanel;
    private JCheckBox accumulateCheckBox;
    private JCheckBox showController;

    public TClickCellActionsPanel(ArrayList boardList) {
        this(DEFAULT_TITLE, boardList);
    }

    public TClickCellActionsPanel(String title, ArrayList boardList) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), title));
        this.createSelectBoardPanel(boardList);
        this.createAccumulatePanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)this.selectBoardPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.gridx = 1;
        c2.gridy = 0;
        this.add((Component)this.accumulatePanel, c2);
    }

    private void createSelectBoardPanel(ArrayList boardList) {
        this.selectBoardPanel = new JPanel();
        this.selectBoardPanel.setLayout(new FlowLayout(0));
        JLabel boardLabel = new JLabel(TLanguage.getString("TClickCellActionsPanel.GO_TO"));
        this.followingBoardComboBox = new JComboBox();
        this.followingBoardComboBox.setPreferredSize(new Dimension(150, 20));
        Vector boards = new Vector();
        boards.add(null);
        boards.addAll(boardList);
        this.followingBoardComboBox.setModel(new DefaultComboBoxModel(boards));
        this.followingBoardComboBox.setEnabled(boards.size() > 1);
        this.selectBoardPanel.add(boardLabel);
        this.selectBoardPanel.add(this.followingBoardComboBox);
    }

    private void createAccumulatePanel() {
        this.accumulatePanel = new JPanel();
        this.accumulatePanel.setLayout(new FlowLayout(2));
        this.accumulateCheckBox = new JCheckBox(TLanguage.getString("TClickCellActionsPanel.ACCUMULATE_CELL"));
        this.accumulatePanel.add(this.accumulateCheckBox);
    }

    public String getFollowingBoard() {
        return (String)this.followingBoardComboBox.getSelectedItem();
    }

    public void setFollowingBoard(String followingBoard) {
        this.followingBoardComboBox.setSelectedItem(followingBoard);
    }

    public boolean getAccumulated() {
        return this.accumulateCheckBox.isSelected();
    }

    public void setAccumulated(boolean accumulated) {
        this.accumulateCheckBox.setSelected(accumulated);
    }
}

