/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tico.components.TButton;
import tico.components.TOrderList;
import tico.components.TUnorderList;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;

public class TBoardOrderPanel
extends JPanel {
    private TUnorderList unorderedList;
    private JPanel buttonPanel;
    private TButton addOrderedButton;
    private TButton removeOrderedButton;
    private TOrderList orderedList;

    public TBoardOrderPanel() {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TBoardOrderPanel.TITLE")));
        JLabel unorderedLabel = new JLabel(TLanguage.getString("TBoardOrderPanel.WITHOUT_ORDER"));
        this.createUnorderedCellList();
        this.createButtonPanel();
        JLabel orderedLabel = new JLabel(TLanguage.getString("TBoardOrderPanel.WITH_ORDER"));
        this.createOrderedCellList();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)unorderedLabel, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        this.add((Component)this.unorderedList, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 2;
        this.add((Component)this.buttonPanel, c2);
        c2.fill = 2;
        c2.insets = new Insets(5, 10, 0, 10);
        c2.gridx = 0;
        c2.gridy = 3;
        this.add((Component)orderedLabel, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 4;
        this.add((Component)this.orderedList, c2);
        this.updateComponents();
    }

    private void createUnorderedCellList() {
        this.unorderedList = new TUnorderList();
        this.unorderedList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                TBoardOrderPanel.this.updateComponents();
            }
        });
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.addOrderedButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TBoardOrderPanel.this.addOrdered();
            }
        });
        this.addOrderedButton.setIcon(TResourceManager.getImageIcon("move-add-16.png"));
        this.addOrderedButton.setMargin(new Insets(2, 2, 2, 2));
        this.addOrderedButton.setToolTipText(TLanguage.getString("TBoardOrderPanel.ADD_TO_ORDER_TOOLTIP"));
        this.removeOrderedButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TBoardOrderPanel.this.removeOrdered();
            }
        });
        this.removeOrderedButton.setIcon(TResourceManager.getImageIcon("move-remove-16.png"));
        this.removeOrderedButton.setMargin(new Insets(2, 2, 2, 2));
        this.removeOrderedButton.setToolTipText(TLanguage.getString("TBoardOrderPanel.REMOVE_FROM_ORDER_TOOLTIP"));
        this.buttonPanel.add(this.addOrderedButton);
        this.buttonPanel.add(this.removeOrderedButton);
    }

    private void createOrderedCellList() {
        this.orderedList = new TOrderList();
        this.orderedList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                TBoardOrderPanel.this.updateComponents();
            }
        });
    }

    private void addOrdered() {
        if (!this.unorderedList.isSelectionEmpty()) {
            Object object = this.unorderedList.getSelectedValue();
            this.unorderedList.removeSelectedValue();
            this.orderedList.addElement(object);
        }
    }

    private void removeOrdered() {
        if (!this.orderedList.isSelectionEmpty()) {
            Object object = this.orderedList.getSelectedValue();
            this.orderedList.removeSelectedValue();
            this.unorderedList.addElement(object);
        }
    }

    private void updateComponents() {
        this.addOrderedButton.setEnabled(!this.unorderedList.isSelectionEmpty());
        this.removeOrderedButton.setEnabled(!this.orderedList.isSelectionEmpty());
    }

    public ArrayList getOrderedList() {
        return this.orderedList.getList();
    }

    public void setOrderedList(ArrayList cellList) {
        this.orderedList.setList(cellList);
    }

    public ArrayList getUnorderedList() {
        return this.unorderedList.getList();
    }

    public void setUnorderedList(ArrayList cellList) {
        this.unorderedList.setList(cellList);
    }
}

