/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import tico.components.TColorComboBox;
import tico.configuration.TLanguage;
import tico.editor.TEditor;

public class TBackgroundSelectionPanel
extends JPanel {
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private static final Color DEFAULT_GRADIENT_COLOR = null;
    private static final boolean DEFAULT_ALLOW_TRANSPARENT = true;
    private TColorComboBox backgroundColorComboBox;
    private TColorComboBox gradientColorComboBox;

    public TBackgroundSelectionPanel() {
        this(DEFAULT_BACKGROUND_COLOR);
    }

    public TBackgroundSelectionPanel(Color backgroundColor) {
        this(backgroundColor, DEFAULT_GRADIENT_COLOR);
    }

    public TBackgroundSelectionPanel(Color backgroundColor, Color gradientColor) {
        this(backgroundColor, gradientColor, true);
    }

    public TBackgroundSelectionPanel(boolean allowTransparent) {
        this(DEFAULT_BACKGROUND_COLOR, DEFAULT_GRADIENT_COLOR, allowTransparent);
    }

    public TBackgroundSelectionPanel(Color backgroundColor, Color gradientColor, boolean allowTransparent) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TBackgroundSelectionPanel.TITLE")));
        JLabel backgroundColorLabel = new JLabel(TLanguage.getString("TBackgroundSelectionPanel.COLOR"));
        this.backgroundColorComboBox = new TColorComboBox(allowTransparent);
        JLabel gradientColorLabel = new JLabel(TLanguage.getString("TBackgroundSelectionPanel.GRADIENT"));
        this.gradientColorComboBox = new TColorComboBox(true);
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        backgroundColorLabel.setHorizontalAlignment(4);
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 10, 0);
        c2.weightx = 0.5;
        c2.weighty = 1.0;
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)backgroundColorLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 5, 10, 0);
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        c2.gridx = 1;
        c2.gridy = 0;
        this.add((Component)this.backgroundColorComboBox, c2);
        gradientColorLabel.setHorizontalAlignment(4);
        c2.fill = 1;
        c2.insets = new Insets(10, 20, 10, 0);
        c2.weightx = 0.5;
        c2.weighty = 1.0;
        c2.gridx = 2;
        c2.gridy = 0;
        this.add((Component)gradientColorLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 5, 10, 10);
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        c2.gridx = 3;
        c2.gridy = 0;
        this.add((Component)this.gradientColorComboBox, c2);
        this.backgroundColorComboBox.addActionListener(new ChangeColorListener());
        this.setBackgroundColor(backgroundColor);
        this.setGradientColor(gradientColor);
        if (TEditor.get_android_mode()) {
            this.gradientColorComboBox.setEnabled(false);
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColorComboBox.getColor();
    }

    public void setBackgroundColor(Color backgrodundColor) {
        this.backgroundColorComboBox.setColor(backgrodundColor);
    }

    public Color getGradientColor() {
        return this.gradientColorComboBox.getColor();
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColorComboBox.setColor(gradientColor);
    }

    public void addActionListener(ActionListener listener) {
        this.backgroundColorComboBox.addActionListener(listener);
        this.gradientColorComboBox.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.backgroundColorComboBox.removeActionListener(listener);
        this.gradientColorComboBox.removeActionListener(listener);
    }

    private class ChangeColorListener
    implements ActionListener {
        private ChangeColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (TBackgroundSelectionPanel.this.getBackgroundColor() == null) {
                TBackgroundSelectionPanel.this.gradientColorComboBox.setEnabled(false);
            } else {
                TBackgroundSelectionPanel.this.gradientColorComboBox.setEnabled(true);
            }
        }
    }
}

