/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TTextField;
import tico.components.resources.SoundFilter;
import tico.components.resources.TFileUtils;
import tico.components.resources.TResourceManager;
import tico.configuration.TLanguage;
import tico.editor.TFileHandler;
import tico.editor.dialogs.TRecordSound;
import tico.interpreter.threads.TInterpreterMp3Sound;

public class TAlternativeSoundChooser
extends JPanel {
    private static final String DEFAULT_TITLE = TLanguage.getString("TAnotherSoundChosser.TITLE");
    private String soundFilePath;
    private boolean stopPlayback;
    private SourceDataLine sourceDataLine;
    private AudioFormat audioFormat;
    private AudioInputStream audioInputStream;
    private AudioPlayThread audioPlayThread;
    private TInterpreterMp3Sound prueba = null;
    private JPanel soundNamePane;
    private TTextField soundNameTextField;
    private TButton playSoundButton;
    private TButton stopSoundButton;
    private JPanel buttonPanel;
    private TButton clearSoundButton;
    private TButton selectSoundButton;
    private TButton recordSoundButton;
    private static File defaultDirectory = null;

    public TAlternativeSoundChooser() {
        this(DEFAULT_TITLE);
    }

    public TAlternativeSoundChooser(String title) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), title));
        this.createSoundNamePane();
        this.createButtonPanel();
        this.updateComponents();
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)this.soundNamePane, c2);
        c2.fill = 2;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        c2.gridx = 0;
        c2.gridy = 1;
        this.add((Component)this.buttonPanel, c2);
    }

    private void createSoundNamePane() {
        this.soundNamePane = new JPanel();
        this.soundNamePane.setLayout(new FlowLayout());
        JLabel textNameLabel = new JLabel(TLanguage.getString("TSoundChooser.NAME"));
        this.soundNameTextField = new TTextField();
        this.soundNameTextField.setColumns(20);
        this.soundNameTextField.setEditable(false);
        this.playSoundButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TAlternativeSoundChooser.this.playSoundFile();
            }
        });
        this.playSoundButton.setIcon(TResourceManager.getImageIcon("media-start-16.png"));
        this.playSoundButton.setMargin(new Insets(2, 2, 2, 2));
        this.playSoundButton.setToolTipText(TLanguage.getString("TSoundChooser.PLAY_TOOLTIP"));
        this.stopSoundButton = new TButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TAlternativeSoundChooser.this.stopSoundFile();
            }
        });
        this.stopSoundButton.setIcon(TResourceManager.getImageIcon("media-stop-16.png"));
        this.stopSoundButton.setMargin(new Insets(2, 2, 2, 2));
        this.stopSoundButton.setEnabled(false);
        this.stopSoundButton.setToolTipText(TLanguage.getString("TSoundChooser.STOP_TOOLTIP"));
        this.soundNamePane.add(textNameLabel);
        this.soundNamePane.add(this.soundNameTextField);
        this.soundNamePane.add(this.playSoundButton);
        this.soundNamePane.add(this.stopSoundButton);
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.selectSoundButton = new TButton(TLanguage.getString("TSoundChooser.BUTTON_SELECT"));
        this.selectSoundButton.addActionListener(new ChooseSoundButtonListener());
        this.recordSoundButton = new TButton(TLanguage.getString("TSoundChooser.RECORD"));
        this.recordSoundButton.addActionListener(new RecordSoundButtonListener());
        this.clearSoundButton = new TButton(new AbstractAction(TLanguage.getString("TSoundChooser.BUTTON_CLEAR")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TAlternativeSoundChooser.this.setSoundFilePath(null);
            }
        });
        this.buttonPanel.add(this.selectSoundButton);
        this.buttonPanel.add(this.recordSoundButton);
        this.buttonPanel.add(this.clearSoundButton);
    }

    public void updateComponents() {
        if (this.soundFilePath != null) {
            this.playSoundButton.setEnabled(true);
            this.clearSoundButton.setEnabled(true);
            this.soundNameTextField.setText(TFileUtils.getFilename(this.soundFilePath));
            this.soundNameTextField.setCaretPosition(0);
        } else {
            this.playSoundButton.setEnabled(false);
            this.clearSoundButton.setEnabled(false);
            this.soundNameTextField.setText("");
        }
    }

    private void playSoundFile() {
        String extension = TFileUtils.getExtension(this.soundFilePath);
        if (extension.equals("mp3")) {
            this.prueba = new TInterpreterMp3Sound(this.soundFilePath);
            this.prueba.TPlay();
            this.stopSoundButton.setEnabled(true);
            this.playSoundButton.setEnabled(false);
            this.clearSoundButton.setEnabled(false);
            this.selectSoundButton.setEnabled(false);
        } else {
            try {
                int sampleSizeInBits = 16;
                int internalBufferSize = -1;
                File soundFile = new File(this.soundFilePath);
                this.audioInputStream = AudioSystem.getAudioInputStream(soundFile);
                this.audioFormat = this.audioInputStream.getFormat();
                DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat, internalBufferSize);
                boolean isSuportedDirectly = AudioSystem.isLineSupported(dataLineInfo);
                if (!isSuportedDirectly) {
                    AudioFormat sourceFormat = this.audioFormat;
                    AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), sampleSizeInBits, sourceFormat.getChannels(), sourceFormat.getChannels() * (sampleSizeInBits / 8), sourceFormat.getSampleRate(), false);
                    this.audioInputStream = AudioSystem.getAudioInputStream(targetFormat, this.audioInputStream);
                    this.audioFormat = this.audioInputStream.getFormat();
                }
                dataLineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat, internalBufferSize);
                this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
                this.sourceDataLine.open(this.audioFormat, internalBufferSize);
                this.stopPlayback = false;
                this.stopSoundButton.setEnabled(true);
                this.playSoundButton.setEnabled(false);
                this.clearSoundButton.setEnabled(false);
                this.selectSoundButton.setEnabled(false);
                this.audioPlayThread = new AudioPlayThread();
                this.audioPlayThread.start();
            }
            catch (UnsupportedAudioFileException e2) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TSoundChooser.INVALID_FORMAT_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
            }
            catch (LineUnavailableException e3) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TSoundChooser.PLAY_FAILURE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
            }
            catch (IOException e4) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TSoundChooser.OPEN_FILE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
            }
        }
    }

    private void stopSoundFile() {
        if (this.prueba != null) {
            this.prueba.TStop();
        } else {
            this.stopPlayback = true;
        }
        this.stopSoundButton.setEnabled(false);
        this.playSoundButton.setEnabled(true);
        this.clearSoundButton.setEnabled(true);
        this.selectSoundButton.setEnabled(true);
    }

    public String getSoundFilePath() {
        return this.soundFilePath;
    }

    public void setSoundFilePath(String soundFilePath) {
        this.soundFilePath = soundFilePath;
        this.updateComponents();
    }

    public class AudioPlayThread
    extends Thread {
        private static final int EXTERNAL_BUFFER_SIZE = 4096;

        @Override
        public void run() {
            byte[] tempBuffer = new byte[4096];
            try {
                TAlternativeSoundChooser.this.sourceDataLine.start();
                int readBytes = 0;
                while (readBytes != -1 && !TAlternativeSoundChooser.this.stopPlayback) {
                    readBytes = TAlternativeSoundChooser.this.audioInputStream.read(tempBuffer, 0, tempBuffer.length);
                    if (readBytes <= 0) continue;
                    TAlternativeSoundChooser.this.sourceDataLine.write(tempBuffer, 0, readBytes);
                }
                TAlternativeSoundChooser.this.sourceDataLine.drain();
                TAlternativeSoundChooser.this.sourceDataLine.close();
                TAlternativeSoundChooser.this.stopSoundFile();
            }
            catch (Exception e2) {
                TAlternativeSoundChooser.this.stopSoundFile();
                JOptionPane.showMessageDialog(null, TLanguage.getString("TSoundChooser.OPEN_FILE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
            }
        }
    }

    private class ChooseSoundButtonListener
    implements ActionListener {
        private ChooseSoundButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(TLanguage.getString("TSoundChooser.CHOOSE_SOUND"));
            fileChooser.setCurrentDirectory(defaultDirectory);
            fileChooser.addChoosableFileFilter(new SoundFilter());
            fileChooser.setAcceptAllFileFilterUsed(false);
            int returnValue = fileChooser.showOpenDialog(null);
            if (returnValue == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                defaultDirectory = selectedFile.getParentFile();
                try {
                    selectedFile = TFileHandler.importFile(selectedFile);
                    TAlternativeSoundChooser.this.setSoundFilePath(selectedFile.getAbsolutePath());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("TSoundChooser.OPEN_FILE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
                }
            }
        }
    }

    private class RecordSoundButtonListener
    implements ActionListener {
        private RecordSoundButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            TRecordSound recordSoundWindow = new TRecordSound();
            if (TRecordSound.text != null) {
                File selectedFile = TRecordSound.text;
                defaultDirectory = selectedFile.getParentFile();
                try {
                    selectedFile = TFileHandler.importFile(selectedFile);
                    TAlternativeSoundChooser.this.setSoundFilePath(selectedFile.getAbsolutePath());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("TSoundChooser.OPEN_FILE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
                }
            }
        }
    }
}

