/*
 * Decompiled with CFR 0.152.
 */
package tico.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import tico.components.TBorderSizeComboBox;
import tico.components.TColorComboBox;
import tico.configuration.TLanguage;

public class TAlternativeBorderSelectionPanel
extends JPanel {
    private static final int DEFAULT_BORDER_SIZE = 4;
    private static final Color DEFAULT_BORDER_COLOR = Color.RED;
    public TColorComboBox colorComboBox;
    public TBorderSizeComboBox borderSizeComboBox;

    public TAlternativeBorderSelectionPanel() {
        this(DEFAULT_BORDER_COLOR, 4);
    }

    public TAlternativeBorderSelectionPanel(Color borderColor) {
        this(borderColor, 4);
    }

    public TAlternativeBorderSelectionPanel(int borderSize) {
        this(DEFAULT_BORDER_COLOR, borderSize);
    }

    public TAlternativeBorderSelectionPanel(Color borderColor, int borderSize) {
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TAnotherBorderSelectionPanel.TITLE")));
        JLabel colorLabel = new JLabel(TLanguage.getString("TBorderSelectionPanel.COLOR"));
        this.colorComboBox = new TColorComboBox(false);
        JLabel borderSizeLabel = new JLabel(TLanguage.getString("TBorderSelectionPanel.SIZE"));
        this.borderSizeComboBox = new TBorderSizeComboBox();
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        colorLabel.setHorizontalAlignment(4);
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 10, 0);
        c2.weightx = 0.5;
        c2.weighty = 1.0;
        c2.gridx = 0;
        c2.gridy = 0;
        this.add((Component)colorLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 5, 10, 0);
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        c2.gridx = 1;
        c2.gridy = 0;
        this.add((Component)this.colorComboBox, c2);
        borderSizeLabel.setHorizontalAlignment(4);
        c2.fill = 1;
        c2.insets = new Insets(10, 20, 10, 0);
        c2.weightx = 0.5;
        c2.weighty = 1.0;
        c2.gridx = 2;
        c2.gridy = 0;
        this.add((Component)borderSizeLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 5, 10, 10);
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        c2.gridx = 3;
        c2.gridy = 0;
        this.add((Component)this.borderSizeComboBox, c2);
        this.colorComboBox.addActionListener(new ChangeColorListener());
        this.setBorderColor(borderColor);
        this.setBorderSize(borderSize);
    }

    public Color getBorderColor() {
        return this.colorComboBox.getColor();
    }

    public void setBorderColor(Color borderColor) {
        this.colorComboBox.setColor(borderColor);
    }

    public int getBorderSize() {
        return this.borderSizeComboBox.getBorderSize();
    }

    public void setBorderSize(int borderSize) {
        this.borderSizeComboBox.setBorderSize(borderSize);
    }

    public Border getSelectedBorder() {
        if (this.getBorderColor() != null) {
            return BorderFactory.createLineBorder(this.getBorderColor(), this.getBorderSize());
        }
        return null;
    }

    public void addActionListener(ActionListener listener) {
        this.colorComboBox.addActionListener(listener);
        this.borderSizeComboBox.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.colorComboBox.removeActionListener(listener);
        this.borderSizeComboBox.removeActionListener(listener);
    }

    private class ChangeColorListener
    implements ActionListener {
        private ChangeColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (TAlternativeBorderSelectionPanel.this.getBorderColor() == null) {
                TAlternativeBorderSelectionPanel.this.borderSizeComboBox.setEnabled(false);
            } else {
                TAlternativeBorderSelectionPanel.this.borderSizeComboBox.setEnabled(true);
            }
        }
    }
}

