/*
 * Decompiled with CFR 0.152.
 */
package tico.board.encoding;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jgraph.graph.AttributeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tico.board.encoding.InvalidFormatException;
import tico.components.resources.TFileUtils;
import tico.editor.TFileHandler;
import tico.editor.TProjectHandler;

public class TAttributeEncoder {
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String COLOR_TYPE = "color";
    private static final String FONT_TYPE = "font";
    private static final String RECTANGLE_TYPE = "rectangle";
    private static final String SIZE_TYPE = "size";
    private static final String LIST_TYPE = "list";
    private static final String STRING_TYPE = "string";
    private static final String FLOAT_TYPE = "float";
    private static final String INTEGER_TYPE = "integer";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final String ICON_TYPE = "icon";
    private static final String FILE_TYPE = "file";

    public static Node XMLEncode(AttributeMap map, Document doc) {
        Element attributesElement = doc.createElement("attributes");
        Iterator attributeIterator = map.entrySet().iterator();
        while (attributeIterator.hasNext()) {
            attributesElement.appendChild(TAttributeEncoder.writeAttribute(attributeIterator.next(), doc));
        }
        return attributesElement;
    }

    public static AttributeMap XMLDecode(Element element) throws InvalidFormatException {
        if (element.getTagName().equals("attributes")) {
            AttributeMap map = new AttributeMap();
            NodeList attributeNodeList = element.getChildNodes();
            int i2 = 0;
            while (i2 < attributeNodeList.getLength()) {
                Node attributeNode = attributeNodeList.item(i2);
                if (attributeNode.getNodeType() == 1) {
                    map.putAll(TAttributeEncoder.readAttribute((Element)attributeNode));
                }
                ++i2;
            }
            return map;
        }
        throw new InvalidFormatException();
    }

    private static Node writeAttribute(Map.Entry entry, Document doc) {
        Element attributesElement = doc.createElement("attribute");
        String key = (String)entry.getKey();
        Object value = entry.getValue();
        attributesElement.setAttribute(KEY_ATTRIBUTE, key);
        if (value instanceof Color) {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, COLOR_TYPE);
            attributesElement.appendChild(doc.createTextNode(Integer.toHexString(((Color)value).getRGB())));
        } else if (value instanceof Font) {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, FONT_TYPE);
            Font font = (Font)value;
            Element familyElement = doc.createElement("family");
            familyElement.appendChild(doc.createTextNode(font.getFamily()));
            Element sizeElement = doc.createElement(SIZE_TYPE);
            sizeElement.appendChild(doc.createTextNode("" + font.getSize()));
            Element boldElement = doc.createElement("bold");
            Element italicElement = doc.createElement("italic");
            attributesElement.appendChild(familyElement);
            attributesElement.appendChild(sizeElement);
            if (font.isBold()) {
                attributesElement.appendChild(boldElement);
            }
            if (font.isItalic()) {
                attributesElement.appendChild(italicElement);
            }
        } else if (value instanceof AttributeMap.SerializableRectangle2D) {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, RECTANGLE_TYPE);
            Rectangle2D rectangle = (Rectangle2D)value;
            Element xElement = doc.createElement("x");
            xElement.appendChild(doc.createTextNode("" + rectangle.getX()));
            Element yElement = doc.createElement("y");
            yElement.appendChild(doc.createTextNode("" + rectangle.getY()));
            Element widthElement = doc.createElement("width");
            widthElement.appendChild(doc.createTextNode("" + rectangle.getWidth()));
            Element heightElement = doc.createElement("height");
            heightElement.appendChild(doc.createTextNode("" + rectangle.getHeight()));
            attributesElement.appendChild(xElement);
            attributesElement.appendChild(yElement);
            attributesElement.appendChild(widthElement);
            attributesElement.appendChild(heightElement);
        } else if (value instanceof Dimension) {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, SIZE_TYPE);
            Dimension dimension = (Dimension)value;
            Element widthElement = doc.createElement("width");
            widthElement.appendChild(doc.createTextNode(Double.toString(dimension.getWidth())));
            Element heightElement = doc.createElement("height");
            heightElement.appendChild(doc.createTextNode(Double.toString(dimension.getHeight())));
            attributesElement.appendChild(widthElement);
            attributesElement.appendChild(heightElement);
        } else if (value instanceof Object[]) {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, LIST_TYPE);
            int i2 = 0;
            while (i2 < ((Object[])value).length) {
                Element elementNode = doc.createElement("element");
                elementNode.appendChild(doc.createTextNode(((Object[])value)[i2].toString()));
                attributesElement.appendChild(elementNode);
                ++i2;
            }
        } else if (value instanceof Float) {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, FLOAT_TYPE);
            attributesElement.appendChild(doc.createTextNode(value.toString()));
        } else if (value instanceof Integer) {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, INTEGER_TYPE);
            attributesElement.appendChild(doc.createTextNode(value.toString()));
        } else if (value instanceof Boolean) {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, BOOLEAN_TYPE);
            attributesElement.appendChild(doc.createTextNode(value.toString()));
        } else if (value instanceof Icon) {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, ICON_TYPE);
            String partialPath = "image" + File.separator + ((ImageIcon)value).getDescription().substring(((ImageIcon)value).getDescription().lastIndexOf(File.separator) + 1);
            attributesElement.appendChild(doc.createTextNode(partialPath));
        } else if (value instanceof File) {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, FILE_TYPE);
            String partialPath = TFileHandler.convertToPartial(((File)value).getAbsolutePath());
            attributesElement.appendChild(doc.createTextNode(partialPath));
        } else {
            attributesElement.setAttribute(TYPE_ATTRIBUTE, STRING_TYPE);
            attributesElement.appendChild(doc.createTextNode(value.toString()));
        }
        return attributesElement;
    }

    private static Map readAttribute(Element element) throws InvalidFormatException {
        if (element.getTagName().equals("attribute")) {
            AttributeMap attribute = new AttributeMap();
            Object value = null;
            if (!element.hasAttribute(KEY_ATTRIBUTE) || !element.hasAttribute(TYPE_ATTRIBUTE)) {
                throw new InvalidFormatException();
            }
            String type = element.getAttribute(TYPE_ATTRIBUTE);
            if (type.equals(COLOR_TYPE)) {
                String hexaValue = element.getChildNodes().item(0).getNodeValue();
                value = new Color((int)Long.parseLong(hexaValue, 16));
            } else if (type.equals(FONT_TYPE)) {
                NodeList sizeElementList;
                NodeList familyElementList = element.getElementsByTagName("family");
                if (familyElementList.getLength() != 1) {
                    throw new InvalidFormatException();
                }
                String family = familyElementList.item(0).getChildNodes().item(0).getNodeValue();
                int style = 0;
                if (element.getElementsByTagName("bold").getLength() == 1) {
                    style |= 1;
                }
                if (element.getElementsByTagName("italic").getLength() == 1) {
                    style |= 2;
                }
                if ((sizeElementList = element.getElementsByTagName(SIZE_TYPE)).getLength() != 1) {
                    throw new InvalidFormatException();
                }
                String sizeValue = sizeElementList.item(0).getChildNodes().item(0).getNodeValue();
                int size = Integer.parseInt(sizeValue);
                value = new Font(family, style, size);
            } else if (type.equals(RECTANGLE_TYPE)) {
                NodeList xElementList = element.getElementsByTagName("x");
                if (xElementList.getLength() != 1) {
                    throw new InvalidFormatException();
                }
                String xValue = xElementList.item(0).getChildNodes().item(0).getNodeValue();
                double x2 = Double.parseDouble(xValue);
                NodeList yElementList = element.getElementsByTagName("y");
                if (yElementList.getLength() != 1) {
                    throw new InvalidFormatException();
                }
                String yValue = yElementList.item(0).getChildNodes().item(0).getNodeValue();
                double y2 = Double.parseDouble(yValue);
                NodeList widthElementList = element.getElementsByTagName("width");
                if (widthElementList.getLength() != 1) {
                    throw new InvalidFormatException();
                }
                String widthValue = widthElementList.item(0).getChildNodes().item(0).getNodeValue();
                double width = Double.parseDouble(widthValue);
                NodeList heightElementList = element.getElementsByTagName("height");
                if (heightElementList.getLength() != 1) {
                    throw new InvalidFormatException();
                }
                String heightValue = heightElementList.item(0).getChildNodes().item(0).getNodeValue();
                double height = Double.parseDouble(heightValue);
                value = new Rectangle2D.Double(x2, y2, width, height);
            } else if (type.equals(SIZE_TYPE)) {
                NodeList widthElementList = element.getElementsByTagName("width");
                if (widthElementList.getLength() != 1) {
                    throw new InvalidFormatException();
                }
                String widthValue = widthElementList.item(0).getChildNodes().item(0).getNodeValue();
                double width = Double.parseDouble(widthValue);
                NodeList heightElementList = element.getElementsByTagName("height");
                if (heightElementList.getLength() != 1) {
                    throw new InvalidFormatException();
                }
                String heightValue = heightElementList.item(0).getChildNodes().item(0).getNodeValue();
                double height = Double.parseDouble(heightValue);
                Dimension dimension = new Dimension();
                dimension.setSize(width, height);
                value = dimension;
            } else if (type.equals(LIST_TYPE)) {
                NodeList elementNodeList = element.getElementsByTagName("element");
                Object[] objectList = new Object[elementNodeList.getLength()];
                int i2 = 0;
                while (i2 < objectList.length) {
                    objectList[i2] = elementNodeList.item(i2).getChildNodes().item(0).getNodeValue();
                    ++i2;
                }
                value = objectList;
            } else if (type.equals(FLOAT_TYPE)) {
                value = new Float(Float.parseFloat(element.getChildNodes().item(0).getNodeValue()));
            } else if (type.equals(INTEGER_TYPE)) {
                value = new Integer(Integer.parseInt(element.getChildNodes().item(0).getNodeValue()));
            } else if (type.equals(STRING_TYPE)) {
                value = element.getChildNodes().getLength() == 0 ? "" : element.getChildNodes().item(0).getNodeValue();
            } else if (type.equals(BOOLEAN_TYPE)) {
                value = Boolean.valueOf(element.getChildNodes().item(0).getNodeValue());
            } else if (type.equals(ICON_TYPE)) {
                File imageFile;
                String partialPath = element.getChildNodes().item(0).getNodeValue();
                partialPath = partialPath.replace('\\', '/');
                try {
                    imageFile = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath));
                }
                catch (IOException e2) {
                    throw new InvalidFormatException();
                }
                if (TFileUtils.isJAIRequired(imageFile)) {
                    RenderedOp src = JAI.create("fileload", imageFile.getAbsolutePath());
                    BufferedImage bufferedImage = src.getAsBufferedImage();
                    value = new ImageIcon(bufferedImage, imageFile.getAbsolutePath());
                } else {
                    value = new ImageIcon(imageFile.getAbsolutePath(), imageFile.getAbsolutePath());
                }
            } else if (type.equals(FILE_TYPE)) {
                String partialPath = element.getChildNodes().item(0).getNodeValue();
                partialPath = partialPath.replace('\\', '/');
                try {
                    value = TFileHandler.importFile(new File(TProjectHandler.getTempDirectory(), partialPath));
                }
                catch (Exception e3) {
                    throw new InvalidFormatException();
                }
            }
            if (value == null) {
                throw new InvalidFormatException();
            }
            attribute.put(element.getAttribute(KEY_ATTRIBUTE), value);
            return attribute;
        }
        return null;
    }

    public static String[] getFilePaths(Document doc) {
        Vector<String> filePaths = new Vector<String>();
        NodeList attributesNodeList = doc.getElementsByTagName("attributes");
        int i2 = 0;
        while (i2 < attributesNodeList.getLength()) {
            NodeList attributeNodeList = attributesNodeList.item(i2).getChildNodes();
            int j2 = 0;
            while (j2 < attributeNodeList.getLength()) {
                Element attributeNode;
                if (attributeNodeList.item(j2).getNodeType() == 1 && (attributeNode = (Element)attributeNodeList.item(j2)).getTagName().equals("attribute") && attributeNode.hasAttribute(KEY_ATTRIBUTE) && attributeNode.hasAttribute(TYPE_ATTRIBUTE)) {
                    String partialPath;
                    String type = attributeNode.getAttribute(TYPE_ATTRIBUTE);
                    if (type.equals(ICON_TYPE)) {
                        partialPath = attributeNode.getChildNodes().item(0).getNodeValue();
                        filePaths.add(partialPath);
                    } else if (type.equals(FILE_TYPE)) {
                        partialPath = attributeNode.getChildNodes().item(0).getNodeValue();
                        filePaths.add(partialPath);
                    }
                }
                ++j2;
            }
            ++i2;
        }
        String[] paths = new String[filePaths.size()];
        int i3 = 0;
        while (i3 < filePaths.size()) {
            paths[i3] = (String)filePaths.get(i3);
            ++i3;
        }
        return paths;
    }
}

