/*
 * Decompiled with CFR 0.152.
 */
package tico.board.componentview;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import tico.board.TBoardConstants;
import tico.board.componentredenerer.TLineRenderer;
import tico.board.componentview.TComponentView;

public class TLineView
extends TComponentView {
    public static transient TLineRenderer renderer = new TLineRenderer();

    public TLineView() {
    }

    public TLineView(Object line) {
        super(line);
    }

    @Override
    public CellViewRenderer getRenderer() {
        return renderer;
    }

    @Override
    public CellHandle getHandle(GraphContext context) {
        if (TBoardConstants.isSizeable(this.getAllAttributes()) && !TBoardConstants.isAutoSize(this.getAllAttributes()) && context.getGraph().isSizeable()) {
            return new TLineHandle(this, context);
        }
        return null;
    }

    protected static int opositeCorner(int corner) {
        switch (corner) {
            case 0: {
                return 7;
            }
            case 2: {
                return 5;
            }
            case 5: {
                return 2;
            }
            case 7: {
                return 0;
            }
        }
        return -1;
    }

    public static class TLineHandle
    extends VertexView.SizeHandle {
        protected transient int startCorner;

        public TLineHandle(VertexView vertexview, GraphContext ctx) {
            super(vertexview, ctx);
            int corner = TBoardConstants.getStartCorner(vertexview.getAllAttributes());
            int[] myCursors = new int[9];
            int i2 = 0;
            while (i2 < this.cursors.length) {
                if (i2 == corner || i2 == TLineView.opositeCorner(corner)) {
                    myCursors[i2] = 12;
                }
                ++i2;
            }
            this.cursors = myCursors;
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.startCorner = TBoardConstants.getStartCorner(this.vertex.getAllAttributes());
            super.mousePressed(event);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Rectangle2D t2;
            Graphics g2;
            if (this.firstDrag && this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            Rectangle2D dirty = null;
            Graphics graphics = g2 = this.offgraphics != null ? this.offgraphics : this.graph.getGraphics();
            if (this.index == -1) {
                return;
            }
            Rectangle2D newBounds = this.computeBounds(event);
            int newCorner = this.computeStartCorner(event);
            g2.setColor(this.graph.getForeground());
            g2.setXORMode(this.graph.getBackground().darker());
            this.overlay(g2);
            if (this.offgraphics != null) {
                dirty = this.graph.toScreen((Rectangle2D)this.vertex.getBounds().clone());
                t2 = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (t2 != null) {
                    dirty.add(t2);
                }
            }
            if (this.cachedBounds != null) {
                this.cachedBounds = newBounds;
            } else {
                CellView[] all = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                int i2 = 0;
                while (i2 < all.length) {
                    CellView orig = this.graph.getGraphLayoutCache().getMapping(all[i2].getCell(), false);
                    if (orig != null) {
                        AttributeMap origAttr = (AttributeMap)orig.getAllAttributes().clone();
                        all[i2].changeAttributes(origAttr);
                        all[i2].refresh(this.graph.getModel(), this.context, false);
                    }
                    ++i2;
                }
                this.vertex.setBounds(newBounds);
                TBoardConstants.setStartCorner(this.vertex.getAttributes(), newCorner);
                if (this.vertex != null) {
                    this.graph.getGraphLayoutCache().update(this.vertex);
                }
                if (this.contextViews != null) {
                    this.graph.getGraphLayoutCache().update(this.contextViews);
                }
            }
            this.overlay(g2);
            if (this.offscreen != null) {
                dirty.add(this.graph.toScreen((Rectangle2D)this.vertex.getBounds().clone()));
                t2 = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (t2 != null) {
                    dirty.add(t2);
                }
                int border = PortView.SIZE + 10;
                if (this.graph.isPortsScaled()) {
                    border = (int)(this.graph.getScale() * (double)border);
                }
                int border2 = border / 2;
                dirty.setFrame(dirty.getX() - (double)border2, dirty.getY() - (double)border2, dirty.getWidth() + (double)border, dirty.getHeight() + (double)border);
                double sx1 = Math.max(0.0, dirty.getX());
                double sy1 = Math.max(0.0, dirty.getY());
                double sx2 = sx1 + dirty.getWidth();
                double sy2 = sy1 + dirty.getHeight();
                this.graph.getGraphics().drawImage(this.offscreen, (int)sx1, (int)sy1, (int)sx2, (int)sy2, (int)sx1, (int)sy1, (int)sx2, (int)sy2, this.graph);
            }
        }

        @Override
        protected Rectangle2D computeBounds(MouseEvent event) {
            Rectangle2D r2 = super.computeBounds(event);
            float min = TBoardConstants.getLineWidth(this.vertex.getAttributes());
            r2 = new Rectangle2D.Double(r2.getX(), r2.getY(), ((double)min < r2.getWidth() ? r2.getWidth() : (double)min) + 1.0, ((double)min < r2.getHeight() ? r2.getHeight() : (double)min) + 1.0);
            return r2;
        }

        protected int computeStartCorner(MouseEvent event) {
            double left = this.initialBounds.getX();
            double right = this.initialBounds.getX() + this.initialBounds.getWidth() - 1.0;
            double top = this.initialBounds.getY();
            double bottom = this.initialBounds.getY() + this.initialBounds.getHeight() - 1.0;
            Point2D p2 = this.graph.fromScreen(this.graph.snap((Point2D)event.getPoint().clone()));
            p2.setLocation(Math.max(0.0, p2.getX()), Math.max(0.0, p2.getY()));
            if (this.index > 4) {
                bottom = p2.getY();
            } else if (this.index < 3) {
                top = p2.getY();
            }
            if (this.index == 0 || this.index == 3 || this.index == 5) {
                left = p2.getX();
            } else if (this.index == 2 || this.index == 4 || this.index == 7) {
                right = p2.getX();
            }
            double width = right - left;
            double height = bottom - top;
            if (this.isConstrainedSizeEvent(event) || GraphConstants.isConstrained(this.vertex.getAllAttributes())) {
                if (this.index == 3 || this.index == 4 || this.index == 5) {
                    height = width;
                } else if (this.index == 1 || this.index == 6 || this.index == 2 || this.index == 7) {
                    width = height;
                } else {
                    height = width;
                }
            }
            if (width < 0.0 && height < 0.0) {
                switch (this.startCorner) {
                    case 0: {
                        return 7;
                    }
                    case 2: {
                        return 5;
                    }
                    case 5: {
                        return 2;
                    }
                    case 7: {
                        return 0;
                    }
                }
            }
            if (width < 0.0) {
                switch (this.startCorner) {
                    case 0: {
                        return 2;
                    }
                    case 2: {
                        return 0;
                    }
                    case 5: {
                        return 7;
                    }
                    case 7: {
                        return 5;
                    }
                }
            }
            if (height < 0.0) {
                switch (this.startCorner) {
                    case 0: {
                        return 5;
                    }
                    case 2: {
                        return 7;
                    }
                    case 5: {
                        return 0;
                    }
                    case 7: {
                        return 2;
                    }
                }
            }
            return this.startCorner;
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (this.index != -1) {
                this.cachedBounds = this.computeBounds(e2);
                int cachedStartPoint = this.computeStartCorner(e2);
                this.vertex.setBounds(this.cachedBounds);
                TBoardConstants.setStartCorner(this.vertex.getAttributes(), cachedStartPoint);
                Object[] views = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                Map attributes = GraphConstants.createAttributes(views, null);
                this.graph.getGraphLayoutCache().edit(attributes, null, null, null);
            }
            e2.consume();
            this.cachedBounds = null;
            this.initialBounds = null;
            this.firstDrag = true;
        }
    }
}

