/*
 * Decompiled with CFR 0.152.
 */
package tico.board.components;

import org.jgraph.graph.AttributeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.board.encoding.InvalidFormatException;
import tico.board.encoding.TAttributeEncoder;
import tico.configuration.TLanguage;

public class TTextArea
extends TComponent {
    public static String TYPE = "textArea";
    private static int textAreaCount = 0;
    private static String DEFAULT_TEXT = TLanguage.getString("TTextArea.DEFAULT_TEXT");

    public TTextArea() {
        this.setAllowsChildren(false);
        TBoardConstants.setText(this.getAttributes(), DEFAULT_TEXT);
        TBoardConstants.setTextReceiver(this.getAttributes(), true);
    }

    @Override
    public String newId() {
        return "textArea_" + new Integer(textAreaCount++);
    }

    @Override
    public Node XMLEncode(Document doc) {
        Element componentElement = doc.createElement("component");
        componentElement.setAttribute("type", TYPE);
        AttributeMap map = (AttributeMap)this.getAttributes().clone();
        map.remove("textReceiver");
        componentElement.appendChild(TAttributeEncoder.XMLEncode(map, doc));
        return componentElement;
    }

    public static TTextArea XMLDecode(Element element) throws InvalidFormatException {
        if (element.getTagName().equals("component") && element.getAttribute("type").equals(TYPE)) {
            TTextArea textArea = new TTextArea();
            Node attributesNode = element.getElementsByTagName("attributes").item(0);
            textArea.getAttributes().applyMap(TAttributeEncoder.XMLDecode((Element)attributesNode));
            return textArea;
        }
        return null;
    }
}

